/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.api;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

import java.util.Map;

/**
 * Uses multiple sources to aggregate information pertaining to a given resource (usually a page)
 */
public interface PageInfoAggregator {

    /**
     * Get all information available on the given resource
     *
     * @param request the servlet request
     * @param resource the resource to aggregate information for
     * @return Map containing all available information for the resource
     */
    public Map<String, Object> getAggregatedPageInfo(SlingHttpServletRequest request, Resource resource);
}
