/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.api;

import javax.servlet.ServletRequest;

/*
 * The WCM mode defines the type of modes the WCM has in the current
 * request.
 */
public enum WCMMode {

    /**
     * The WCM is disabled. This is usually the case on a 'publish' instance
     * where the normal WCM capabilities are disabled.
     */
    DISABLED,

    /**
     * The WCM is in edit mode. This is the normal case for authoring instances
     */
    EDIT,

    /**
     * The WCM is in preview mode. Only a limited set of WCM UI elements are
     * visible.
     */
    PREVIEW,
    
    /**
     * The WCM is in analytics mode. WCM UI elements are visible which are analyzable.
     */
    ANALYTICS,

    /**
     * The WCM is in read only mode. Only WCM UI elements are visible that
     * are not used for editing.
     */
    READ_ONLY,

    /**
     * The WCM is in design mode. 
     */
    DESIGN;

    /**
     * name of the WCMMode request attribute
     */
    public static final String REQUEST_ATTRIBUTE_NAME = WCMMode.class.getName();

    /**
     * Returns the current WCM Mode of this request.
     * @param req servlet request
     * @return current WCM Mode
     */
    public static WCMMode fromRequest(ServletRequest req) {
        WCMMode mode = (WCMMode) req.getAttribute(REQUEST_ATTRIBUTE_NAME);
        return mode == null ? WCMMode.DISABLED : mode;
    }

    /**
     * Sets the current WCM Mode of this request.
     * @param req servlet request
     * @return previous WCM Mode
     */
    public WCMMode toRequest(ServletRequest req) {
        WCMMode prev = (WCMMode) req.getAttribute(REQUEST_ATTRIBUTE_NAME);
        req.setAttribute(REQUEST_ATTRIBUTE_NAME, this);
        // never return NULL
        return prev == null ? DISABLED : prev;
    }

}