/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.core.utils;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;

import com.day.text.Text;

/**
 * Helpers for scaffolding.
 */
public class ScaffoldingUtils {

    /**
     * The name of the request attribute used to store the scaffolding context (ie: the resource
     * being edited via the scaffolding).
     */
    public static String CONTEXT_RESOURCE_ATTR_NAME = "com.day.cq.wcm.scaffolding.resource";

    /**
     * Search the scaffolding hierarchy starting at node (normally /etc/scaffolding) for a scaffold
     * which targets the given template.
     * @param node the node
     * @param template the template
     * @return String scaffold
     * @throws RepositoryException the RepositoryException
     */
    public static String findScaffoldByTemplate(Node node, String template) throws RepositoryException {
        if (node.hasProperty("jcr:content/cq:targetTemplate")) {
            String tt = node.getProperty("jcr:content/cq:targetTemplate").getString();
            if (tt.equals(template)) {
                return node.getPath();
            }
        }
        NodeIterator iter = node.getNodes();
        String scaffold = null;
        while (scaffold == null && iter.hasNext()) {
            Node child = iter.nextNode();
            if (!child.getName().equals("jcr:content")) {
                scaffold = findScaffoldByTemplate(child, template);
            }
        }
        return scaffold;
    }

    /**
     * Search the scaffolding hierarchy starting at node (normally /etc/scaffolding) for a scaffold
     * which targets the given path (or an ancestor of the given path).
     * @param node the node
     * @param path the given path for which scaffolding hierarchy to be searched.
     * @return String the Scaffold.
     * @throws RepositoryException the RepositoryException
     */
    public static String findScaffoldByPath(Node node, String path) throws RepositoryException {
        if (node.hasProperty("jcr:content/cq:targetPath")) {
            String tt = node.getProperty("jcr:content/cq:targetPath").getString();
            if (Text.isDescendantOrEqual(tt, path)) {
                return node.getPath();
            }
        }
        NodeIterator iter = node.getNodes();
        String scaffold = null;
        while (scaffold == null && iter.hasNext()) {
            Node child = iter.nextNode();
            if (!child.getName().equals("jcr:content")) {
                scaffold = findScaffoldByPath(child, path);
            }
        }
        return scaffold;
    }
}
