/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.foundation.search;

import javax.jcr.query.Row;

import com.day.cq.dam.api.Asset;
import com.day.cq.search.Predicate;
import com.day.cq.search.eval.AbstractPredicateEvaluator;
import com.day.cq.search.eval.EvaluationContext;
import org.apache.felix.scr.annotations.Component;
import org.apache.sling.api.resource.Resource;

/**
 * Filters out sub assets from the search results.
 *
 * <p>
 * This is a filtering-only predicate and cannot leverage a search index.
 * <p>
 * Does not support facet extraction.
 *
 * <h3>Name:</h3>
 * subAssetFilter
 *
 * <h3>Properties:</h3>
 * <dl>
 * <dt>subAssetFilter</dt>
 * <dd>any value</dd>
 * </dl>
 *
 * @since 6.3
 */
@Component(metatype = false, factory = "com.day.cq.search.eval.PredicateEvaluator/subAssetFilter")
public class SubAssetFilterPredicateEvaluator extends AbstractPredicateEvaluator {

    @Override
    public boolean includes(Predicate p, Row row, EvaluationContext context) {
        Resource res = context.getResource(row);
        if (res != null) {
            // if the resource is a sub-asset, we discard it
            Asset asset = res.adaptTo(Asset.class);
            return !(asset != null && asset.isSubAsset());
        }
        return false;
    }

    @Override
    public boolean canXpath(Predicate predicate, EvaluationContext context) {
        return false;
    }

    @Override
    public boolean canFilter(Predicate predicate, EvaluationContext context) {
        return true;
    }

}
