/*
 * Copyright 1997-2011 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.mobile.api.device;

import java.util.Map;

/**
 * A <code>DeviceGroupFilter</code> specifies filtering of device groups against a user agent extracted from the request
 * and a set of mobile device capabilities extracted from the WURFL database.
 */
public interface DeviceGroupFilter {

    /**
     * Returns a human-readable description of what this device group filter does.
     *
     * @return The description.
     */
    String getDescription();

    /**
     * Returns a human-readable title for offering filter choices in the UI.
     *
     * @return The title.
     */
    String getTitle();

    /**
     * Indicates whether the given device <code>group</code> matches the <code>userAgent</code> and mobile
     * <code>capabilities</code> extracted from the request and the WURFL database.
     *
     * @param group        The {@link DeviceGroup} to be matched against user agent and capabilities.
     * @param userAgent    The user agent string as extracted from the request.
     * @param capabilities The mobile device capabilities as extracted from the WURFL database.
     *
     * @return <code>true</code> if the device group matches the user agent and capabilities.
     */
    boolean matches(DeviceGroup group, String userAgent, Map<String, String> capabilities);
}
