/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.scripting;

import org.apache.sling.api.resource.ValueMap;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.EditContext;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;

public final class WCMBindingsConstants {

    private WCMBindingsConstants() {
        // only constants
    }

    /**
     * Name for the scripting variable referencing the
     * {@link ComponentContext} object (value is "{@value}").
     */
    public static final String NAME_COMPONENT_CONTEXT = "componentContext";

    /**
     * Name for the scripting variable referencing the
     * {@link EditContext} object (value is "{@value}").
     */
    public static final String NAME_EDIT_CONTEXT = "editContext";

    /**
     * Name for the scripting variable referencing the
     * {@link ValueMap properties} of the current resource (value is "{@value}").
     */
    public static final String NAME_PROPERTIES = "properties";

    /**
     * Name for the scripting variable referencing the
     * {@link PageManager} object (value is "{@value}").
     */
    public static final String NAME_PAGE_MANAGER = "pageManager";

    /**
     * Name for the scripting variable referencing the
     * {@link Page current page} object (value is "{@value}").
     */
    public static final String NAME_CURRENT_PAGE = "currentPage";

    /**
     * Name for the scripting variable referencing the
     * {@link Page resource page} object (value is "{@value}").
     */
    public static final String NAME_RESOURCE_PAGE = "resourcePage";

    /**
     * Name for the scripting variable referencing the
     * {@link InheritanceValueMap page properties} of the current page (value is "{@value}").
     */
    public static final String NAME_PAGE_PROPERTIES = "pageProperties";

    /**
     * Name for the scripting variable referencing the
     * {@link Component} of the current resource (value is "{@value}").
     */
    public static final String NAME_COMPONENT = "component";

    /**
     * Name for the scripting variable referencing the
     * {@link Designer} object (value is "{@value}").
     */
    public static final String NAME_DESIGNER = "designer";

    /**
     * Name for the scripting variable referencing the
     * {@link Design design} of the current page (value is "{@value}").
     */
    public static final String NAME_CURRENT_DESIGN = "currentDesign";

    /**
     * Name for the scripting variable referencing the
     * {@link Design design} of the resource page (value is "{@value}").
     */
    public static final String NAME_RESOURCE_DESIGN = "resourceDesign";

    /**
     * Name for the scripting variable referencing the
     * {@link Style style} of the current cell (value is "{@value}").
     */
    public static final String NAME_CURRENT_STYLE = "currentStyle";

    /**
     * Name for the scripting variable referencing the
     * {@link XSSAPI xssAPI protection service} currently in use (value is "{@value}").
     */
    public static final String NAME_XSSAPI = "xssAPI";

    /**
     * Name for the scripting variable referencing the current {@link com.day.cq.wcm.api.policies.ContentPolicy} of the current cell (value is
     * "{@value}").
     */
    public static final String NAME_CURRENT_CONTENT_POLICY = "currentContentPolicy";

    /**
     * Name for the scripting variable referencing the properties of the current content policy (value is "{@value}").
     */
    public static final String NAME_CURRENT_CONTENT_POLICY_PROPS = "currentContentPolicyProperties";
}
