/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 1997 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.crx.io;

import java.io.IOException;
import java.io.InputStream;

import javax.jcr.ImportUUIDBehavior;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;

/**
 * This Interface defines...
 *
 */
public interface CRXImportHandler {

    /**
     * flag for intermediate node handling
     */
    int IH_ERROR = 0;

    /**
     * flag for intermediate node handling
     */
    int IH_AUTO = 1;

    /**
     * flag for intermediate node handling
     */
    int IH_COPY = 2;

    /**
     * flag for intermediate node handling
     */
    int IH_FIXED = 3;

    boolean importCRX(String absPath, InputStream in) throws IOException, RepositoryException;

    int getIntermediateHandling();

    void setIntermediateHandling(int intermediateHandling);

    String getIntermediateNodeType() throws NamespaceException;

    void setIntermediateNodeType(String intermediateNodeType) throws NamespaceException;

    /**
     * @see ImportUUIDBehavior
     * @return the uuid behaviour
     */
    int getUuidBehavior();

    /**
     * @see ImportUUIDBehavior
     * @param uuidBehavior
     */
    void setUuidBehavior(int uuidBehavior);


}
