/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 1997 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.statistics.query;

import com.day.crx.statistics.Report;

import javax.jcr.Session;
import javax.jcr.RepositoryException;
import javax.jcr.Node;
import javax.jcr.Item;
import javax.jcr.NodeIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Calendar;
import java.util.ArrayList;

import org.apache.jackrabbit.util.Text;

/**
 * <code>RecentQueriesReport</code> returns a list of the most recent queries.
 *
 * @author mreutegg
 */
public class RecentQueriesReport extends Report {

    /**
     * Number of queries to return at most. Default value: top 10 queries.
     */
    private int size = 10;

    /**
     * Creates a new report.
     *
     * @param dataPath path where query statistics are stored.
     */
    public RecentQueriesReport(String dataPath) {
        super(dataPath);
    }

    /**
     * {@inheritDoc}
     * Returns result rows with the following objects:
     * <ul>
     * <li>Recent query <code>String</code></li>
     * </ul>
     */
    public Iterator getResult(Session session) throws RepositoryException {
        Calendar cal = Calendar.getInstance();
        Query dummy = new Query(getDataPath(), "dummy", 1, 1);
        List result = new ArrayList();
        // go back at most 10 days
        for (int i = 0; i < 10; i++) {
            dummy.setTimestamp(cal.getTimeInMillis());
            String p = Text.getRelativeParent(dummy.getPath(), 1);
            if (session.itemExists(p)) {
                Item item = session.getItem(p);
                if (item.isNode()) {
                    Node day = (Node) item;
                    List queries = new ArrayList();
                    for (NodeIterator it = day.getNodes(); it.hasNext(); ) {
                        queries.add(Text.unescapeIllegalJcrChars(it.nextNode().getName()));
                    }
                    for (int j = queries.size() - 1; j >= 0 && result.size() < getSize(); j--) {
                        if (!result.contains(queries.get(j))) {
                            result.add(queries.get(j));
                        }
                    }
                }
            }
            if (result.size() >= getSize()) {
                break;
            }
            cal.add(Calendar.DAY_OF_MONTH, -1);
        }
        for (int i = 0; i < result.size(); i++) {
            result.set(i, new Object[]{result.get(i)});
        }
        return result.iterator();
    }

    /**
     * @return the maximum number of queries to return.
     */
    public int getSize() {
        return size;
    }

    /**
     * @param size the maximum number of queries to return.
     */
    public void setSize(int size) {
        this.size = size;
    }
}
