/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.pmp.datamatrixpmp;

import com.adobe.xfa.pmp.common.IntegerHolder;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixAsciiCompactor;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixBaseCompactor;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixByteCompactor;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixC40Compactor;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixEncoderErrorCode;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixEncoderException;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixTextCompactor;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixX12Compactor;
import java.util.List;

class DataMatrixCompactorManager {
    DataMatrixCompactorManager() {
    }

    static void compact(char[] message, List<Integer> codeWords, IntegerHolder symbolSize) throws DataMatrixEncoderException {
        DataMatrixAsciiCompactor asciiCompactor = new DataMatrixAsciiCompactor();
        asciiCompactor.compact(message);
        DataMatrixByteCompactor byteCompactor = new DataMatrixByteCompactor();
        byteCompactor.compact(message);
        DataMatrixC40Compactor c40Compactor = new DataMatrixC40Compactor();
        c40Compactor.compact(message);
        DataMatrixTextCompactor textCompactor = new DataMatrixTextCompactor();
        textCompactor.compact(message);
        DataMatrixX12Compactor x12Compactor = new DataMatrixX12Compactor();
        x12Compactor.compact(message);
        DataMatrixBaseCompactor minCompactor = null;
        if (byteCompactor.isValid()) {
            minCompactor = byteCompactor;
        } else if (asciiCompactor.isValid()) {
            minCompactor = asciiCompactor;
        } else if (c40Compactor.isValid()) {
            minCompactor = c40Compactor;
        } else if (textCompactor.isValid()) {
            minCompactor = textCompactor;
        } else if (x12Compactor.isValid()) {
            minCompactor = x12Compactor;
        }
        if (minCompactor == null) {
            throw new DataMatrixEncoderException(DataMatrixEncoderErrorCode.MESSAGE_TOO_BIG);
        }
        int minSymbolSize = minCompactor.getSymbolSize();
        if (textCompactor.isValid() && textCompactor.getSymbolSize() < minSymbolSize) {
            minCompactor = textCompactor;
            minSymbolSize = minCompactor.getSymbolSize();
        }
        if (c40Compactor.isValid() && c40Compactor.getSymbolSize() < minSymbolSize) {
            minCompactor = c40Compactor;
            minSymbolSize = minCompactor.getSymbolSize();
        }
        if (asciiCompactor.isValid() && asciiCompactor.getSymbolSize() <= minSymbolSize) {
            minCompactor = asciiCompactor;
            minSymbolSize = minCompactor.getSymbolSize();
        }
        if (x12Compactor.isValid() && x12Compactor.getSymbolSize() < minSymbolSize) {
            minCompactor = x12Compactor;
            minSymbolSize = minCompactor.getSymbolSize();
        }
        minCompactor.getCodeWords(codeWords);
        symbolSize.setValue(minSymbolSize);
    }
}

