/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.pmp.datamatrixpmp;

import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixEncoderErrorCode;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixEncoderException;
import com.adobe.xfa.pmp.datamatrixpmp.DataMatrixMatrix;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

class DataMatrixImageBuilder {
    DataMatrixImageBuilder() {
    }

    private static Color getColor(int color) {
        if (color == 0) {
            return Color.BLACK;
        }
        return Color.WHITE;
    }

    static BufferedImage buildImage(DataMatrixMatrix matrix, int imageCols, int imageRows, int xDimension) throws DataMatrixEncoderException {
        int cols = matrix.getCols();
        int rows = matrix.getRows();
        if (imageCols <= 0) {
            imageCols = (cols + 2) * xDimension;
        }
        if (imageRows <= 0) {
            imageRows = (rows + 2) * xDimension;
        }
        int colOffset = (imageCols - cols * xDimension) / 2;
        int rowOffset = (imageRows - rows * xDimension) / 2;
        if (colOffset < xDimension || rowOffset < xDimension) {
            throw new DataMatrixEncoderException(DataMatrixEncoderErrorCode.IMAGE_TOO_SMALL);
        }
        BufferedImage image = new BufferedImage(imageCols, imageRows, 10);
        Graphics2D graphicsBarcodeImage = image.createGraphics();
        graphicsBarcodeImage.setColor(Color.WHITE);
        graphicsBarcodeImage.fillRect(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        graphicsBarcodeImage.clipRect(0, 0, imageCols - colOffset, imageRows - rowOffset);
        int color = 0;
        int i = 0;
        int imageRow = rowOffset;
        while (i < rows) {
            int j = 0;
            int imageCol = colOffset;
            while (j < cols) {
                color = matrix.get(j, i) != 0 ? 0 : 255;
                graphicsBarcodeImage.setColor(DataMatrixImageBuilder.getColor(color));
                graphicsBarcodeImage.fillRect(imageCol, imageRow, imageCol + xDimension, imageRow + xDimension);
                ++j;
                imageCol += xDimension;
            }
            ++i;
            imageRow += xDimension;
        }
        return image;
    }
}

