/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.handler;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMetaFactory;
import com.day.cq.dam.api.Context;
import com.day.cq.dam.api.Processor;
import com.day.cq.dam.api.ProcessorException;
import com.day.cq.dam.commons.handler.Filter;
import com.day.cq.dam.commons.handler.FilterStateListener;
import com.day.cq.dam.commons.handler.SimpleContext;
import com.day.cq.dam.commons.handler.XPacketFilter;
import com.day.cq.dam.commons.metadata.XmpFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class XMPProcessor
implements Processor,
FilterStateListener {
    private Context context;
    private XPacketFilter topFilter;

    public XMPProcessor(Context context) {
        this.context = context;
        this.topFilter = new XPacketFilter();
        this.topFilter.setFilterStateListener(this);
        this.topFilter.setAutoReset(true);
    }

    @Override
    public final void process(byte[] buf, int off, int len) throws IOException {
        this.topFilter.filter(buf, off, len);
    }

    @Override
    public OutputStream started(Filter filter) {
        return new ByteArrayOutputStream(8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ended(Filter filter, OutputStream out) {
        ByteArrayOutputStream bos = (ByteArrayOutputStream)out;
        BundleContext bundleContext = this.getBundleContext();
        ServiceReference filterRef = bundleContext.getServiceReference(XmpFilter.class);
        try {
            if (filterRef != null) {
                XmpFilter xmpFilter = (XmpFilter)bundleContext.getService(filterRef);
                if (xmpFilter != null) {
                    byte[] buf = bos.toByteArray();
                    ByteArrayInputStream bis = new ByteArrayInputStream(buf);
                    XMPMetaFactory.parse(xmpFilter.filter(bis));
                    this.context.addMetadata(new ByteArrayInputStream(buf));
                } else {
                    String msg = "Unable to get XMPFilter service.";
                    this.context.addException(new ProcessorException(msg, new Exception(msg), this));
                }
            } else {
                String msg = "Unable to get XMPFilter service.";
                this.context.addException(new ProcessorException(msg, new Exception(msg), this));
            }
        }
        catch (XMPException | IOException e) {
            String msg = "Unable to get XMP object from input";
            this.context.addException(new ProcessorException(msg, e, this));
        }
        finally {
            if (filterRef != null) {
                bundleContext.ungetService(filterRef);
            }
        }
    }

    public static InputStream process(InputStream in) throws IOException, ProcessorException {
        int len;
        SimpleContext context = new SimpleContext();
        XMPProcessor processor = new XMPProcessor(context);
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) > 0) {
            processor.process(buf, 0, len);
        }
        InputStream[] metadata = context.getMetadata();
        if (metadata != null && metadata.length > 0) {
            return metadata[0];
        }
        ProcessorException[] exceptions = context.getExceptions();
        if (exceptions != null) {
            throw exceptions[exceptions.length - 1];
        }
        return null;
    }

    BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(this.getClass()).getBundleContext();
    }
}

