/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import aQute.bnd.annotation.ProviderType;
import com.day.cq.dam.api.s7dam.config.DynamicMediaServicesConfig;
import java.util.Calendar;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.tenant.Tenant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public class DynamicMediaServicesConfigUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicMediaServicesConfigUtil.class);
    private static final int REGISTRATION_EXPIRES_SECONDS = 10800;
    private static byte[] key = new byte[]{111, 110, 39, 116, 32, 102, 111, 114, 103, 101, 116, 32, 116, 111, 100, 114};
    private static final String CONF_GLOBAL_SETTINGS = "/conf/global/settings/cloudconfigs/dynamicmediaservices";

    public static boolean isDynamicMediaServiceConfigured(ResourceResolver resolver) {
        return DynamicMediaServicesConfigUtil.isDynamicMediaServiceConfigured(resolver, null);
    }

    public static boolean isDynamicMediaServiceConfigured(ResourceResolver resolver, String assetPath) {
        return DynamicMediaServicesConfigUtil.getDefaultConfig(resolver, assetPath) != null;
    }

    public static DynamicMediaServicesConfig getDefaultConfig(ResourceResolver resourceResolver) {
        return DynamicMediaServicesConfigUtil.getDefaultConfig(resourceResolver, null);
    }

    public static DynamicMediaServicesConfig getDefaultConfig(ResourceResolver resourceResolver, String assetPath) {
        String tenantId;
        Tenant tenant;
        String suffix = "";
        if (assetPath != null && (tenant = DynamicMediaServicesConfigUtil.getTenant(resourceResolver, assetPath)) != null && (tenantId = tenant.getId()) != null && tenantId.length() > 0) {
            suffix = "/" + tenantId;
        }
        return DynamicMediaServicesConfigUtil.getConfig(resourceResolver, suffix);
    }

    private static DynamicMediaServicesConfig getConfig(ResourceResolver resourceResolver, String suffix) {
        Resource cloudResource = resourceResolver.getResource(CONF_GLOBAL_SETTINGS);
        if (cloudResource == null) {
            cloudResource = resourceResolver.getResource("/etc/cloudservices/dynamicmediaservices" + suffix);
        }
        if (cloudResource != null) {
            Iterator<Resource> dmConfigResourceIter = cloudResource.listChildren();
            while (dmConfigResourceIter.hasNext()) {
                DynamicMediaServicesConfig config = DynamicMediaServicesConfigUtil.getConfig(dmConfigResourceIter.next());
                if (config == null) continue;
                return config;
            }
        }
        return null;
    }

    private static DynamicMediaServicesConfig getConfig(Resource resource) {
        DynamicMediaServicesConfig config;
        if (resource != null && (config = resource.adaptTo(DynamicMediaServicesConfig.class)) != null && !StringUtils.isEmpty(config.getRegistrationId()) && !StringUtils.isEmpty(config.getServiceUrl())) {
            return config;
        }
        return null;
    }

    public static String getRegistrationId(ResourceResolver resourceResolver) {
        return DynamicMediaServicesConfigUtil.getRegistrationId(resourceResolver, null);
    }

    public static String getRegistrationId(ResourceResolver resourceResolver, String assetPath) {
        DynamicMediaServicesConfig config = DynamicMediaServicesConfigUtil.getDefaultConfig(resourceResolver, assetPath);
        Calendar cal = Calendar.getInstance();
        long registrationTimeout = cal.getTimeInMillis() + 10800000L;
        try {
            if (config != null) {
                return DynamicMediaServicesConfigUtil.encrypt(config.getRegistrationId() + "|" + String.valueOf(registrationTimeout));
            }
        }
        catch (Exception e) {
            LOG.error("Failed while creating encrypted key [{}]", (Object)e.getMessage());
        }
        return null;
    }

    public static String getRegistrationId(Resource resource) {
        Tenant tenant = DynamicMediaServicesConfigUtil.getTenant(resource);
        DynamicMediaServicesConfig config = DynamicMediaServicesConfigUtil.getDefaultConfigForTenant(resource.getResourceResolver(), tenant.getId());
        return DynamicMediaServicesConfigUtil.getRegistrationIdFromTenant(config);
    }

    public static String getRegistrationIdFromTenant(DynamicMediaServicesConfig config) {
        Calendar cal = Calendar.getInstance();
        long registrationTimeout = cal.getTimeInMillis() + 10800000L;
        try {
            if (config != null) {
                return DynamicMediaServicesConfigUtil.encrypt(config.getRegistrationId() + "|" + String.valueOf(registrationTimeout));
            }
        }
        catch (Exception e) {
            LOG.error("Failed while creating encrypted key [{}]", (Object)e.getMessage());
        }
        return null;
    }

    private static String encrypt(String strToEncrypt) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            cipher.init(1, secretKey);
            String enc = Base64.encodeBase64String(cipher.doFinal(strToEncrypt.getBytes()));
            return enc.replaceAll("/", "_slash_").replaceAll("\\?", "_qmark_");
        }
        catch (Exception e) {
            LOG.error("Error while encrypting", e);
            return null;
        }
    }

    public static String getPublicKey(ResourceResolver resourceResolver) {
        return DynamicMediaServicesConfigUtil.getPublicKey(resourceResolver, null);
    }

    public static String getPublicKey(ResourceResolver resourceResolver, String assetPath) {
        try {
            String regId;
            DynamicMediaServicesConfig config = DynamicMediaServicesConfigUtil.getDefaultConfig(resourceResolver, assetPath);
            if (config != null && StringUtils.isNotBlank(regId = config.getRegistrationId()) && regId.contains("|")) {
                return StringUtils.substringAfter(regId, "|");
            }
        }
        catch (Exception e) {
            LOG.error("Failed while extracting public key [{}]", (Object)e.getMessage());
        }
        return null;
    }

    public static String getServiceUrl(ResourceResolver resourceResolver) {
        return DynamicMediaServicesConfigUtil.getServiceUrl(resourceResolver, null);
    }

    public static String getServiceUrl(ResourceResolver resourceResolver, String assetPath) {
        String videoServiceUrl = null;
        DynamicMediaServicesConfig config = DynamicMediaServicesConfigUtil.getDefaultConfig(resourceResolver, assetPath);
        if (config != null) {
            videoServiceUrl = config.getServiceUrl();
            if (videoServiceUrl.length() > 0) {
                return videoServiceUrl;
            }
        } else {
            String path = "/etc/cloudservices/dynamicmediaservices/jcr:content";
            Resource res = resourceResolver.getResource(path);
            if (res != null) {
                videoServiceUrl = (String)((Object)res.getValueMap().get("serviceUrl", String.class));
            }
        }
        return videoServiceUrl;
    }

    public static String getServiceUrl(Resource resource) {
        Tenant tenant = DynamicMediaServicesConfigUtil.getTenant(resource);
        DynamicMediaServicesConfig config = DynamicMediaServicesConfigUtil.getDefaultConfigForTenant(resource.getResourceResolver(), tenant.getId());
        return DynamicMediaServicesConfigUtil.getServiceUrlFromTenant(config);
    }

    public static String getServiceUrlFromTenant(DynamicMediaServicesConfig config) {
        String videoServiceUrl = null;
        if (config != null && (videoServiceUrl = config.getServiceUrl()).length() > 0) {
            return videoServiceUrl;
        }
        return videoServiceUrl;
    }

    public static DynamicMediaServicesConfig getDefaultConfigForTenant(ResourceResolver resourceResolver, String tenantId) {
        Resource cloudResource = resourceResolver.getResource("/etc/cloudservices/dynamicmediaservices/" + tenantId);
        Iterator<Resource> dmConfigResourceIter = cloudResource.listChildren();
        while (dmConfigResourceIter.hasNext()) {
            DynamicMediaServicesConfig config = dmConfigResourceIter.next().adaptTo(DynamicMediaServicesConfig.class);
            if (config == null || StringUtils.isEmpty(config.getRegistrationId()) || StringUtils.isEmpty(config.getServiceUrl())) continue;
            return config;
        }
        return null;
    }

    public static String getImageServiceUrl(ResourceResolver resourceResolver) {
        return DynamicMediaServicesConfigUtil.getImageServiceUrl(resourceResolver, null);
    }

    public static String getImageServiceUrl(ResourceResolver resourceResolver, String assetPath) {
        String imageServiceUrl = "";
        DynamicMediaServicesConfig config = DynamicMediaServicesConfigUtil.getDefaultConfig(resourceResolver, assetPath);
        if (config != null) {
            imageServiceUrl = config.getImageServiceUrl();
        }
        return imageServiceUrl;
    }

    private static Tenant getTenant(ResourceResolver resourceResolver, String assetPath) {
        if (assetPath != null) {
            Resource assetResource = resourceResolver.getResource(assetPath);
            return assetResource.adaptTo(Tenant.class);
        }
        return null;
    }

    private static Tenant getTenant(Resource resource) {
        return resource.adaptTo(Tenant.class);
    }
}

