/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.parser;

import com.day.cq.wcm.designimporter.parser.HTMLContentType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HTMLContent {
    private StringBuffer markupBuffer = new StringBuffer();
    private StringBuffer cssBuffer = new StringBuffer();
    private StringBuffer scriptBuffer = new StringBuffer();
    private List<String> referencedScripts = new ArrayList<String>();
    private List<String> referencedStyleSheets = new ArrayList<String>();
    private Map<String, String> metaData = new HashMap<String, String>();

    public Object get(HTMLContentType htmlContentType) {
        switch (htmlContentType) {
            case META: {
                return this.metaData;
            }
            case MARKUP: {
                return this.markupBuffer.toString();
            }
            case SCRIPT_INCLUDE: {
                return this.referencedScripts;
            }
            case SCRIPT_INLINE: {
                return this.scriptBuffer.toString();
            }
            case STYLES_INLINE: {
                return this.cssBuffer.toString();
            }
            case STYLESHEET_INCLUDE: {
                return this.referencedStyleSheets;
            }
        }
        return null;
    }

    public void add(HTMLContentType htmlContentType, Object content) {
        switch (htmlContentType) {
            case META: {
                this.metaData.putAll((Map)content);
                break;
            }
            case MARKUP: {
                this.markupBuffer.append(content);
                break;
            }
            case SCRIPT_INCLUDE: {
                this.referencedScripts.addAll((Collection)content);
                break;
            }
            case SCRIPT_INLINE: {
                this.scriptBuffer.append(content);
                break;
            }
            case STYLES_INLINE: {
                this.cssBuffer.append(content);
                break;
            }
            case STYLESHEET_INCLUDE: {
                this.referencedStyleSheets.addAll((Collection)content);
            }
        }
    }
}

