/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base;

import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashSet;
import javax.jcr.Credentials;
import javax.jcr.GuestCredentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.security.auth.Subject;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.AbstractSlingRepositoryManager;
import org.apache.sling.jcr.base.internal.mount.ProxyRepository;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public abstract class AbstractSlingRepository2
implements SlingRepository {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AbstractSlingRepositoryManager manager;
    private final Bundle usingBundle;

    protected AbstractSlingRepository2(AbstractSlingRepositoryManager manager, Bundle usingBundle) {
        this.manager = manager;
        this.usingBundle = usingBundle;
        if (usingBundle == null) {
            throw new IllegalArgumentException("usingBundle is null");
        }
    }

    protected final AbstractSlingRepositoryManager getSlingRepositoryManager() {
        return this.manager;
    }

    protected final Repository getRepository() {
        return this.getSlingRepositoryManager().getRepository();
    }

    @Override
    public final String getDefaultWorkspace() {
        return this.getSlingRepositoryManager().getDefaultWorkspace();
    }

    protected abstract Session createAdministrativeSession(String var1) throws RepositoryException;

    private Session createServiceSession(Bundle usingBundle, String subServiceName, String workspaceName) throws RepositoryException {
        ServiceUserMapper serviceUserMapper = this.getSlingRepositoryManager().getServiceUserMapper();
        if (serviceUserMapper != null) {
            Session session = null;
            Iterable<String> principalNames = serviceUserMapper.getServicePrincipalNames(usingBundle, subServiceName);
            if (principalNames != null) {
                session = this.createServiceSession(principalNames, workspaceName);
            } else {
                String userName = serviceUserMapper.getServiceUserID(usingBundle, subServiceName);
                if (userName != null) {
                    session = this.createServiceSession(userName, workspaceName);
                }
            }
            if (session != null) {
                Repository repository = this.getRepository();
                return repository instanceof ProxyRepository ? ((ProxyRepository)repository).wrap(session) : session;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session createServiceSession(String serviceUserName, String workspace) throws RepositoryException {
        Session admin = null;
        try {
            admin = this.createAdministrativeSession(workspace);
            Session result = admin.impersonate(new SimpleCredentials(serviceUserName, new char[0]));
            Repository repository = this.getRepository();
            Session session = repository instanceof ProxyRepository ? ((ProxyRepository)repository).wrap(result) : result;
            return session;
        }
        finally {
            if (admin != null) {
                admin.logout();
            }
        }
    }

    protected Session createServiceSession(Iterable<String> servicePrincipalNames, final String workspaceName) throws RepositoryException {
        HashSet<1> principals = new HashSet<1>();
        for (final String pName : servicePrincipalNames) {
            if (pName == null || pName.isEmpty()) continue;
            principals.add(new Principal(){

                @Override
                public String getName() {
                    return pName;
                }
            });
        }
        Subject subject = new Subject(true, principals, Collections.emptySet(), Collections.emptySet());
        try {
            return Subject.doAsPrivileged(subject, new PrivilegedExceptionAction<Session>(){

                @Override
                public Session run() throws Exception {
                    return AbstractSlingRepository2.this.getRepository().login(null, workspaceName);
                }
            }, null);
        }
        catch (PrivilegedActionException e) {
            throw new RepositoryException("failed to retrieve service session.", e);
        }
    }

    @Override
    public Session login() throws LoginException, RepositoryException {
        return this.login(null, null);
    }

    @Override
    public Session login(Credentials credentials) throws LoginException, RepositoryException {
        return this.login(credentials, null);
    }

    @Override
    public Session login(String workspace) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(null, workspace);
    }

    @Override
    public Session login(Credentials credentials, String workspace) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        if (credentials == null) {
            credentials = new GuestCredentials();
        }
        if (workspace == null) {
            workspace = this.getDefaultWorkspace();
        }
        try {
            this.logger.debug("login: Logging in to workspace '" + workspace + "'");
            Repository repository = this.getRepository();
            if (this.getRepository() == null) {
                throw new RepositoryException("Sling Repository not ready");
            }
            Session session = repository.login(credentials, workspace);
            return session;
        }
        catch (RuntimeException re) {
            throw new RepositoryException(re.getMessage(), re);
        }
    }

    @Override
    public final Session loginService(String subServiceName, String workspace) throws LoginException, RepositoryException {
        Session s = this.createServiceSession(this.usingBundle, subServiceName, workspace);
        if (s != null) {
            return s;
        }
        throw new LoginException("Can neither derive user name nor principal names for bundle " + this.usingBundle + " and sub service " + subServiceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session impersonateFromService(String subServiceName, Credentials credentials, String workspaceName) throws LoginException, RepositoryException {
        Session serviceSession = null;
        try {
            serviceSession = this.createServiceSession(this.usingBundle, subServiceName, workspaceName);
            if (serviceSession == null) {
                throw new LoginException("Cannot create service session for bundle " + this.usingBundle + " and sub service " + subServiceName);
            }
            Session session = serviceSession.impersonate(credentials);
            return session;
        }
        finally {
            if (serviceSession != null) {
                serviceSession.logout();
            }
        }
    }

    @Override
    public final Session loginAdministrative(String workspace) throws RepositoryException {
        boolean whitelisted = this.getSlingRepositoryManager().allowLoginAdministrativeForBundle(this.usingBundle);
        if (!whitelisted) {
            String symbolicName = this.usingBundle.getSymbolicName();
            this.logger.error("Bundle {} is NOT whitelisted to use SlingRepository.loginAdministrative", (Object)symbolicName);
            throw new LoginException("Bundle " + symbolicName + " is NOT whitelisted");
        }
        if (this.getSlingRepositoryManager().isDisableLoginAdministrative()) {
            this.logger.error("SlingRepository.loginAdministrative is disabled. Please use SlingRepository.loginService.");
            throw new LoginException("SlingRepository.loginAdministrative is disabled.");
        }
        this.logger.debug("SlingRepository.loginAdministrative is deprecated. Please use SlingRepository.loginService.");
        Session result = this.createAdministrativeSession(workspace);
        Repository repository = this.getRepository();
        return repository instanceof ProxyRepository ? ((ProxyRepository)repository).wrap(result) : result;
    }

    @Override
    public String getDescriptor(String name) {
        Repository repo = this.getRepository();
        if (repo != null) {
            return repo.getDescriptor(name);
        }
        this.logger.error("getDescriptor: Repository not available");
        return null;
    }

    @Override
    public String[] getDescriptorKeys() {
        Repository repo = this.getRepository();
        if (repo != null) {
            return repo.getDescriptorKeys();
        }
        this.logger.error("getDescriptorKeys: Repository not available");
        return new String[0];
    }

    @Override
    public Value getDescriptorValue(String key) {
        Repository repo = this.getRepository();
        if (repo != null) {
            return repo.getDescriptorValue(key);
        }
        this.logger.error("getDescriptorValue: Repository not available");
        return null;
    }

    @Override
    public Value[] getDescriptorValues(String key) {
        Repository repo = this.getRepository();
        if (repo != null) {
            return repo.getDescriptorValues(key);
        }
        this.logger.error("getDescriptorValues: Repository not available");
        return null;
    }

    @Override
    public boolean isSingleValueDescriptor(String key) {
        Repository repo = this.getRepository();
        if (repo != null) {
            return repo.isSingleValueDescriptor(key);
        }
        this.logger.error("isSingleValueDescriptor: Repository not available");
        return false;
    }

    @Override
    public boolean isStandardDescriptor(String key) {
        Repository repo = this.getRepository();
        if (repo != null) {
            return repo.isStandardDescriptor(key);
        }
        this.logger.error("isStandardDescriptor: Repository not available");
        return false;
    }
}

