/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.compiler.expression.nodes;

import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.NodeVisitor;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator;

public final class BinaryOperation
implements ExpressionNode {
    private BinaryOperator operator;
    private ExpressionNode leftOperand;
    private ExpressionNode rightOperand;
    private Expression parentExpression;

    public BinaryOperation(BinaryOperator operator2, ExpressionNode leftOperand, ExpressionNode rightOperand) {
        this.operator = operator2;
        this.leftOperand = leftOperand;
        this.rightOperand = rightOperand;
    }

    public BinaryOperation(BinaryOperator operator2, ExpressionNode leftOperand, ExpressionNode rightOperand, Expression parentExpression) {
        this(operator2, leftOperand, rightOperand);
        this.parentExpression = parentExpression;
    }

    public BinaryOperator getOperator() {
        return this.operator;
    }

    public ExpressionNode getLeftOperand() {
        return this.leftOperand;
    }

    public ExpressionNode getRightOperand() {
        return this.rightOperand;
    }

    public Expression getParentExpression() {
        return this.parentExpression;
    }

    public BinaryOperation withParentExpression(Expression parentExpression) {
        return new BinaryOperation(this.operator, this.leftOperand, this.rightOperand, parentExpression);
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.evaluate(this);
    }

    public String toString() {
        return "BinaryOperation{operator=" + (Object)((Object)this.operator) + ", leftOperand=" + this.leftOperand + ", rightOperand=" + this.rightOperand + '}';
    }
}

