/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2021 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.aem.wcm.seo.sitemap;

import java.util.Locale;
import java.util.Map;

import org.apache.sling.sitemap.spi.generator.SitemapGenerator;
import org.osgi.annotation.versioning.ProviderType;

import com.day.cq.wcm.api.Page;

/**
 * A service that exposes the filters and utility methods the default {@link SitemapGenerator} of for pages uses.
 * <p>
 * It acts as extension point for a delegation pattern implementation, where another {@link SitemapGenerator} replaces the default one but
 * needs to use some of its functionality anyway.
 */
@ProviderType
public interface PageTreeSitemapGenerator extends SitemapGenerator {

    /**
     * Returns a mapping from {@link Locale} to {@link Page} for the language alternatives of the given {@link Page}.
     *
     * @param page the {@link Page} get the alternate language links for
     * @return returns the map of alternate language links of the page as it is added to a Sitemap
     */
    Map<Locale, String> getAlternateLanguageLinks(Page page);

    /**
     * Returns {@code true} when the {@link Page} is published.
     * <p>
     * When called on Publishers, this is always @code true}.
     *
     * @param page the {@link Page} to check
     * @return {@code true} when the page is published, {@code false otherwise}
     */
    boolean isPublished(Page page);

    /**
     * Returns {@code true} when the {@link Page} is set to be not indexed by search engines.
     *
     * @param page the {@link Page} to check
     * @return {@code true} when the page is not to be contained in the Sitemap, {@code false otherwise}
     */
    boolean isNoIndex(Page page);

    /**
     * Returns {@code true} when the {@link Page} has a redirect target.
     *
     * @param page the {@link Page} to check
     * @return {@code true} when the page is a redirect, {@code false otherwise}
     */
    boolean isRedirect(Page page);

    /**
     * Returns {@code true} when the {@link Page} requires authentication.
     *
     * @param page the {@link Page} to check
     * @return {@code true} when the page is a protected by CUG, {@code false otherwise}
     */
    boolean isProtected(Page page);

}
