/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2021 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 *************************************************************************
 */
package com.adobe.cq.dam.cfm.extensions;

import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.ContentFragmentException;

/**
 * ETagCreator generates ETag identifiers
 */
public interface ETagCreator {
    /**
     * Method generates ETag identifier for given string value
     *
     * <p>Generated ETag value represents identifier for specific version of the resource.
     * It means the string value passed to the method needs to be unique for specific version of the resource.</p>
     *
     * @param value the unique string value for specific version of the resource
     * @return ETag identifier or null if ETag generating fails
     */
    String generateETag(String value);

    /**
     * Method generates ETag identifier for given content fragment
     *
     * <p>Generated ETag value represents identifier for specific version of the content fragment.</p>
     *
     * @param contentFragment given content fragment
     * @return ETag identifier
     * @throws ContentFragmentException if ETag generating fails
     */
    String generateETag(ContentFragment contentFragment) throws ContentFragmentException;
}
