/*
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2019 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
package com.adobe.cq.inbox.api.preferences;

import com.adobe.cq.inbox.api.InboxException;
import com.adobe.cq.inbox.api.preferences.domain.view.ViewConfiguration;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.annotation.versioning.ProviderType;

import javax.annotation.Nonnull;

/**
 * Interface for the setting and getting AEM Inbox view configuration
 */
@ProviderType
public interface ViewConfigurationProvider {

    /**
     * Get the {@link ViewConfiguration} of Inbox
     * @param resolver {@link ResourceResolver} of the callee, user should be part of 'workflow-users' group
     * @return The current view configuration of the inbox
     * @throws InboxException {@link InboxException}
     */
    @Nonnull
    ViewConfiguration getViewConfiguration(@Nonnull ResourceResolver resolver) throws InboxException;

    /**
     * Set the {@link ViewConfiguration} of Inbox
     * @param resolver {@link ResourceResolver} of the callee
     * @param viewConfiguration {@link ViewConfiguration} to be stored
     * @throws InboxException {@link InboxException}
     */
    @Nonnull
    void setViewConfiguration(@Nonnull ResourceResolver resolver, @Nonnull ViewConfiguration viewConfiguration) throws InboxException;
}
