/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2020 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.auth.oauth;

import org.osgi.annotation.versioning.ConsumerType;

/**
 * The <code>Provider2</code> extends the {@link Provider} interface and adds
 * the ability to perform log-out operation.
 * <p>
 * If a registered {@link Provider} service implements this interface the
 * {@link #logout(ProviderConfig)} method is called when the user clicks the
 * logout button.
 * 
 * @since 3.12
 */
@ConsumerType
public interface Provider2 extends Provider {

    /**
     * This method will be called when the user clicks the logout button. If a
     * registered {@link Provider} service implements this interface
     * 
     * @param providerConfig
     *            the providerConfig
     * @return the URL where to redirect after logout
     * 
     * @since 3.12
     */
    public String logout(ProviderConfig providerConfig);
}
