/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.exec;

import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.metadata.MetaDataMap;

/**
 * Service Interface to support execution of 3rd party dynamic participant selection code.
 *
 * @see com.adobe.granite.workflow.exec.WorkflowProcess
 */

// This interface is implemented by a service in CQ proper to support
// ParticipantStepChooser custom services.
public interface DynamicParticipantExecutor {

    /**
     * Returns true if this service can process the specified resource, false otherwise.
     * @param workflowStepResource the resource identifying the code to execute for this workflow step.
     * @return true if this service can process the specified resource, false otherwise.
     */
    boolean canExecute(String workflowStepResource);

    /**
     * Returns the dynamically resolved {@link java.security.Principal} id
     *
     * @param resourceName Resource Name
     * @param workItem Current workitem
     * @param workflowSession Workflow session
     * @param metaData Participant chooser specific arguments can be passed here
     *
     * @return the dynamically resolved {@link java.security.Principal} id
     */
    String getParticipant(String resourceName, WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData);
}
