/*
 *
 *	File: PDFSecurityException.java
 *
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.internal.pdftoolkit.core.exceptions;


/**
 * This exception indicates that some general security issue has occured during the
 * processing of the request.  This actual cause may be one of the descendant exceptions
 * to this one.  There are a limited number of these defined within the
 * Adobe PDF Java  Toolkit for the most common cases.  However, a client that is providing its
 * own implementation of the 
 * {@link com.adobe.internal.pdftoolkit.core.securityframework.SecurityHandler SecurityHandler}
 * interface may wish to subclass one of these to provide more specific information.
 */
public class PDFSecurityException extends PDFException
{
	/**
	 * This is a default serialVersionUID.
	 */
	private static final long serialVersionUID = 1L;

	/**
     * Create a new PDFSecurityException.
     * @param message the detail message.
     */
    public PDFSecurityException(String message)
    {
        super(message);
    }
    
    /**
     * Create a new PDFSecurityException wrapping an existing exception.
     * @param message the detail message.
     * @param cause the cause.
     */
    public PDFSecurityException(String message, Throwable cause)
    {
        super(message, cause);
    }
    
    /**
     * Create a new PDFSecurityException wrapping an existing exception.
     * @param cause the cause.
     */
    public PDFSecurityException(Throwable cause)
    {
        super(cause);
    }
}
