/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.configuration;

import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.XFA;


/**
 * A class to represent config objects capable of enclosing other
 * <code>XFAConfigurationKey</code> objects, (i.e., nested keys)
 * and <code>XFAConfigurationValue</code> objects (i.e., values).
 *
 * @author Ian Benedict Carreon
 * @author Mike Tardif (ported to Java)
 * @exclude from published api -- Mike Tardif, May 2006.
 */
public class ConfigurationKey extends ConfigurationElement {

    /**
     * Constructor.
     */
	public ConfigurationKey(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.CONFIGURATIONKEY,
					XFA.CONFIGURATIONKEY, null,
						XFA.CONFIGURATIONKEYTAG, XFA.CONFIGURATIONKEY);
	}


	/**
	 * Is the given attribute tag valid for this configuration key.
	 * 
	 * @param eTag the attribute tag to check.
	 * @return true if valid and false otherwise.
	 *
	 */
	public boolean isValidAttr(int eTag) {
		if (eTag == XFA.CONFIGURATIONKEYTAG)
			return true;
		else if (super.isValidAttr(eTag, false, null))
			return true;
		return false;
	}

	/**
	 * @see Element#isValidChild(int, int, boolean, boolean)
	 */
	public boolean isValidChild(int eTag, int nError, boolean bBeforeInsert,
								boolean bOccurrenceErrorOnly /* = false */) {
		// JavaPort: This method has been overridden...
		// Allow ConfigurationKey's to provisionally have #text children only
		// they have no children of type Element.
		if (eTag == XFA.TEXTNODETAG) {
            for (Node child = getFirstXFAChild(); child != null;) {
                if (child instanceof Element)
                    return false;
                child = child.getNextXFASibling();
            }
			return true;
		}
		return super.isValidChild(eTag, nError, bBeforeInsert,
													bOccurrenceErrorOnly);
	}
}
