/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.template.containers;


import com.adobe.xfa.Arg;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.Obj;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptPropObj;
import com.adobe.xfa.ScriptFuncObj;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.XFA;
import com.adobe.xfa.template.Items;
import com.adobe.xfa.template.containers.Field.ItemPair;
import com.adobe.xfa.ut.StringUtils;


/**
 * This class contains all the script functionality associated with the
 * Field class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class FieldScript extends ContainerScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ContainerScript.moScriptTable,
		"field",
		new ScriptPropObj[] {
			new ScriptPropObj(FieldScript.class, "rawValue", "getRawValue", "setRawValue", Arg.INVALID, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FIELD_RAWVALUE_DESC, 0*/, 0),
			new ScriptPropObj(FieldScript.class, null, "getRawValue", "setRawValue", Arg.INVALID, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/* XFA_IS_FIELD_RAWVALUE_DESC, 0*/, 0),
			new ScriptPropObj(FieldScript.class, "formattedValue", "getFormattedValue", "setFormattedValue", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FIELD_FORMATTEDVALUE_DESC, 0*/, 0),
			new ScriptPropObj(FieldScript.class, "editValue", "getEditValue", "setEditValue", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FIELD_EDITVALUE_DESC, 0*/, 0),
			new ScriptPropObj(FieldScript.class, "isNull", "getIsNull", "setIsNull", Arg.BOOL, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/* XFA_IS_ISnull_DESC, XFA_IS_ISnull_RET*/, 0),
			new ScriptPropObj(FieldScript.class, "mandatory", "getMandatory", "setMandatory", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FIELD_MANDATORY_DESC, 0*/, 0),
			new ScriptPropObj(FieldScript.class, "message", "getValidationMessage", "setValidationMessage", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_DEPRECATED/* XFA_IS_FIELD_MESSAGE_DESC, 0*/, Schema.XFAVERSION_22),
			new ScriptPropObj(FieldScript.class, "validationMessage", "getValidationMessage", "setValidationMessage", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FIELD_MESSAGE_DESC, 0*/, 0),
			new ScriptPropObj(FieldScript.class, "mandatoryMessage", "getMandatoryMessage", "setMandatoryMessage", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FIELD_MANDATORYMESSAGE_DESC, 0*/, 0),
			new ScriptPropObj(FieldScript.class, "formatMessage", "getFormatMessage", "setFormatMessage", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FIELD_FORMATMESSAGE_DESC, 0*/, 0),
			new ScriptPropObj(FieldScript.class, "foreColor", "getForeColor", "setForeColor", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_DEPRECATED/* XFA_IS_FIELD_FORECOLOR_DESC, 0*/, Schema.XFAVERSION_22),
			new ScriptPropObj(FieldScript.class, "fontColor", "getForeColor", "setForeColor", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FIELD_FORECOLOR_DESC, 0*/, 0),
			new ScriptPropObj(FieldScript.class, "backColor", "getBackColor", "setBackColor", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_DEPRECATED/* XFA_IS_FIELD_BACKCOLOR_DESC, 0*/, Schema.XFAVERSION_22),
			new ScriptPropObj(FieldScript.class, "fillColor", "getBackColor", "setBackColor", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FIELD_BACKCOLOR_DESC, 0*/, 0),
			new ScriptPropObj(FieldScript.class, "borderColor", "getBorderColor", "setBorderColor", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FIELD_BORDERCOLOR_DESC, 0*/, 0),
			new ScriptPropObj(FieldScript.class, "borderWidth", "getBorderWidth", "setBorderWidth", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FIELD_BORDERWIDTH_DESC, 0*/, 0),
			new ScriptPropObj(FieldScript.class, "parentSubform", "getParentSubform", null, Arg.OBJECT, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FIELD_PARENTSUBFORM_DESC, 0*/, 0),
			new ScriptPropObj(FieldScript.class, "dataNode", "dataNode", null, Arg.OBJECT, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/* XFA_IS_FORM_DATANODE_DESC, 0*/, 0),
			new ScriptPropObj(FieldScript.class, "length", "getItemsLength", null, Arg.INTEGER, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FORM_GETITEMSLENGTH_DESC, 0*/, 0),
			new ScriptPropObj(FieldScript.class, "selectedIndex", "getSelectedIndex", "setSelectedIndex", Arg.INTEGER, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FORM_SELECTEDINDEX_DESC, XFA_IS_FORM_SELECTEDINDEX_PARAM1*/, 0),
			new ScriptPropObj(FieldScript.class, "errorText", "getErrorText", null, Arg.STRING, Schema.XFAVERSION_30, Schema.XFAAVAILABILITY_ALL/* , XFA_IS_FIELD_ERRORTEXT_DESC, 0*/, 0)
			
		},
		new ScriptFuncObj[] {
			new ScriptFuncObj(FieldScript.class, "addItem", "addItem", Arg.EMPTY,
				new int[] { Arg.STRING, Arg.STRING/*,XFA_IS_FORM_ADDITEM_PARAM1,XFA_IS_FORM_ADDITEM_PARAM2*/}, 1, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FORM_ADDITEM_DESC, 0*/, "addItemPermsCheck", 0),
			new ScriptFuncObj(FieldScript.class, "setItems", "setItems", Arg.BOOL,
				new int[] { Arg.STRING, Arg.INTEGER/*,XFA_IS_FORM_SETITEMS_PARAM1,XFA_IS_FORM_SETITEMS_PARAM2*/ }, 1, Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_ALL /*, XFA_IS_FORM_SETITEMS_DESC, XFA_IS_FORM_SETITEMS_RET*/, "clearItemsPermsCheck", 0),
			new ScriptFuncObj(FieldScript.class, "clearItems", "clearItems", Arg.EMPTY,
				new int[] { }, 0, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FORM_CLEARITEMS_DESC, 0*/, "clearItemsPermsCheck", 0),
			new ScriptFuncObj(FieldScript.class, "deleteItem", "deleteItem", Arg.BOOL,
				new int[] { Arg.INTEGER/*, XFA_IS_FORM_DELETEITEM_PARAM1*/ }, 1, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FORM_DELETEITEM_DESC, XFA_IS_FORM_DELETEITEM_RET*/, "deleteItemPermsCheck", 0),
			new ScriptFuncObj(FieldScript.class, "boundItem", "boundItem", Arg.STRING,
				new int[] { Arg.STRING/*, XFA_IS_FORM_BOUNDITEM_PARAM1*/ }, 1, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FORM_BOUNDITEM_DESC, 0, null*/, 0),
			new ScriptFuncObj(FieldScript.class, "execCalculate", "execCalculate", Arg.EMPTY,
				new int[] { }, 0, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FORM_EXECCALCULATE_DESC, 0, null*/, 0),
			new ScriptFuncObj(FieldScript.class, "execValidate", "execValidate", Arg.BOOL,
				new int[] { }, 0, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FORM_EXECVALIDATE_DESC, XFA_IS_FORM_EXECVALIDATE_RET, null*/, 0),
			new ScriptFuncObj(FieldScript.class, "execInitialize", "execInitialize", Arg.EMPTY,
				new int[] { }, 0, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FORM_EXECINITIALIZE_DESC, 0, null*/, 0),
			new ScriptFuncObj(FieldScript.class, "execEvent", "execEvent", Arg.EMPTY,
				new int[] { Arg.STRING/*, XFA_IS_FORM_EXECEVENT_PARAM1*/ }, 1, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FORM_EXECEVENT_DESC, 0, null*/, 0),
			new ScriptFuncObj(FieldScript.class, "getItemState", "getItemState", Arg.BOOL,
				new int[] { Arg.INTEGER/*, XFA_IS_FORM_GETITEMSTATE_PARAM1*/ }, 1, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FORM_GETITEMSTATE_DESC, XFA_IS_FORM_GETITEMSTATE_RET, null*/, 0),
			new ScriptFuncObj(FieldScript.class, "setItemState", "setItemState", Arg.EMPTY,
				new int[] { Arg.INTEGER, Arg.BOOL/*, XFA_IS_FORM_SETITEMSTATE_PARAM1, XFA_IS_FORM_SETITEMSTATE_PARAM2*/ }, 2, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FORM_SETITEMSTATE_DESC, 0*/, "setItemStatePermsCheck", 0),
			new ScriptFuncObj(FieldScript.class, "getDisplayItem", "getDisplayItem", Arg.STRING,
				new int[] { Arg.INTEGER/*, XFA_IS_FORM_GETDISPLAYITEM_PARAM1*/ }, 1, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FORM_GETDISPLAYITEM_DESC, XFA_IS_FORM_GETDISPLAYITEM_RET, null*/, 0),
			new ScriptFuncObj(FieldScript.class, "getSaveItem", "getSaveItem", Arg.STRING,
				new int[] { Arg.INTEGER/*, XFA_IS_FORM_GETSAVEITEM_PARAM1*/ }, 1, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_ALL/* XFA_IS_FORM_GETSAVEITEM_DESC, XFA_IS_FORM_GETSAVEITEM_RET, null*/, 0)
		}
	);

	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}

	public static void getRawValue(Obj pObj, Arg oRetVal) {
		if (! ((Field) pObj).getIsNull())
			((Field) pObj).getTypedRawValue(oRetVal);
		else
			oRetVal.setNull();
	}

	public static void setRawValue(Obj pObj, Arg propertyValue) {
		String sValue = null;
		if (propertyValue.getArgType() != Arg.NULL)
			sValue = propertyValue.getAsString(false);
		((Field) pObj).setRawValue(sValue);
	}

	public static void getFormattedValue(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Field) pObj).getFormattedValue());
	}

	public static void setFormattedValue(Obj pObj, Arg propertyValue) {
		String sValue = null;
		if (propertyValue.getArgType() != Arg.NULL)
			sValue = propertyValue.getAsString(false);
		((Field) pObj).setFormattedValue(sValue);
	}

	public static void getEditValue(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Field) pObj).getEditValue());
	}

	public static void setEditValue(Obj pObj, Arg propertyValue) {
		String sValue = null;
		if (propertyValue.getArgType() != Arg.NULL)
			sValue = propertyValue.getAsString(false);
		((Field) pObj).setEditValue(sValue);
	}

	public static void getMandatory(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Field) pObj).getMandatory());
	}

	public static void setMandatory(Obj pObj, Arg propertyValue) {
		((Field) pObj).setMandatory(propertyValue.getString());
	}

	public static void getValidationMessage(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Field) pObj).getMessage(XFA.SCRIPTTEST));
	}

	public static void setValidationMessage(Obj pObj, Arg propertyValue) {
		((Field) pObj).setMessage(propertyValue.getString(), XFA.SCRIPTTEST);
	}

	public static void getMandatoryMessage(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Field) pObj).getMessage(XFA.NULLTEST));
	}

	public static void setMandatoryMessage(Obj pObj, Arg propertyValue) {
		((Field) pObj).setMessage(propertyValue.getString(), XFA.NULLTEST);
	}

	public static void getFormatMessage(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Field) pObj).getMessage(XFA.FORMATTEST));
	}

	public static void setFormatMessage(Obj pObj, Arg propertyValue) {
		((Field) pObj).setMessage(propertyValue.getString(), XFA.FORMATTEST);
	}

	public static void getForeColor(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Field) pObj).getForeColor());
	}

	public static void setForeColor(Obj pObj, Arg propertyValue) {
		((Field) pObj).setForeColor(propertyValue.getString());
	}

	public static void getBackColor(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Field) pObj).getBackColor());
	}

	public static void setBackColor(Obj pObj, Arg propertyValue) {
		((Field) pObj).setBackColor(propertyValue.getString());
	}

	public static void getBorderColor(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Field) pObj).getBorderColor());
	}

	public static void setBorderColor(Obj pObj, Arg propertyValue) {
		((Field) pObj).setBorderColor(propertyValue.getString());
	}

	public static void getBorderWidth(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Field) pObj).getBorderWidth());
	}

	public static void setBorderWidth(Obj pObj, Arg propertyValue) {
		((Field) pObj).setBorderWidth(propertyValue.getString());
	}

	public static void getParentSubform(Obj pObj, Arg oRetVal) {
		oRetVal.setObject(((Field) pObj).getParentSubform());
	}

	public static void getIsNull(Obj pObj, Arg oRetVal) {
		oRetVal.setBool(Boolean.valueOf(((Field) pObj).getIsNull()));
	}

	public static void setIsNull(Obj pObj, Arg oArg) {
		((Field) pObj).setIsNull(oArg.getBool().booleanValue(), true);
	}

	public static void dataNode(Obj pObj, Arg oRetVal) {
		oRetVal.setObject(((Field) pObj).getDataNode());
	}

	public static void getItemsLength(Obj pObj, Arg oRetVal) {
		oRetVal.setInteger(Integer.valueOf(((Field) pObj).getItemsLength()));
	}
	
	public static void getErrorText(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Field) pObj).getErrorText());
	}

	public static void getSelectedIndex(Obj pObj, Arg oRetVal) {
		oRetVal.setInteger(Integer.valueOf(((Field) pObj).getSelectedIndex()));
	}

	public static void setSelectedIndex(Obj pObj, Arg oArg) {
		((Field) pObj).setSelectedIndex(oArg.getInteger().intValue());
	}

	public static boolean addItemPermsCheck(Obj obj, Arg[] args) {

		//	Check permissions on the field node and all its ancestors.

		if (obj instanceof Node) {
			Node node = (Node)obj;
			if (! node.checkAncestorPerms())
				return false;
		}
		
		return true;
	}

 	public static boolean clearItemsPermsCheck(Obj obj, Arg[] args) {

 		//	Check permissions on the field node and all its ancestors.
		//	Check permissions on each item and all their decendents.
 		
		if (obj instanceof Field) {
			Field field = (Field)obj;
			
			if (!field.checkAncestorPerms())
				return false;
			
			Field.ItemPair items = new Field.ItemPair();

			// Retrieve the bound and text item lists.
			field.getItemLists(false, items, false);
			
			if (items.mSaveItems != null && !items.mSaveItems.checkDescendentPerms())
				return false;
			
			if (items.mDisplayItems != null && !items.mDisplayItems.checkDescendentPerms())
				return false;
		}
		
		return true;
 	}
	

	public static boolean deleteItemPermsCheck(Obj obj, Arg[] args) {
	
		//	Check permissions on the field node and all its ancestors.
		
		if (obj instanceof Node) {
			Node node = (Node)obj;
			
			if (!node.checkAncestorPerms())
				return false;
		}
		
		return true;
	}

	public static boolean setItemStatePermsCheck(Obj obj, Arg[] args) {

		//	Check permissions on the field node and all its ancestors.

		if (obj instanceof Node) {
			Node node = (Node)obj;
			
			if (!node.checkAncestorPerms())
				return false;
		}
		
		return true;
	}

	public static void addItem(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		String sDisplayVal = null;
		String sSaveVal = null;
		Field.ItemPair items = new Field.ItemPair();
		if (pArgs.length == 1) {
			// Retrieve the bound and text item lists.
			((Field) pObj).getItemLists(false, items, false);
			sDisplayVal = pArgs[0].getAsString(false);
			sSaveVal = sDisplayVal;
		}
		else if (pArgs.length == 2) {
			// Retrieve the bound and text item lists.
			((Field) pObj).getItemLists(false, items, true);
			sDisplayVal = pArgs[0].getAsString(false);
			sSaveVal = pArgs[1].getAsString(false);
		}
		// Retrieve the bound and text item lists.
		Element oSaveItems = items.mSaveItems;
		Element oDisplayItems = items.mDisplayItems;
		if (oDisplayItems != null)	
			((Items) oDisplayItems).addItem(sDisplayVal, false);
		if (oSaveItems != null && oSaveItems != oDisplayItems)
			((Items) oSaveItems).addItem(sSaveVal, false);
	}

	public static void clearItems(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		((Field) pObj).clearItems();
	}
	
	private final static String sSkipSet = "\\,";
	
	public static void setItems(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		Node oSaveItems, oDisplayItems;
		String sDisplayVal = "";
		String sSaveVal;
		int numColumns = 1; // default value 
	  
		// clear the list of items
		((Field)pObj).clearItems();


		String sItemValueList = pArgs[0].getAsString(false);
		StringBuilder sToken = new StringBuilder(); // substring delimited  by a comma char

		if (pArgs.length == 2) {
			numColumns = pArgs[1].getInteger();
		}
		if (numColumns > 2 ) {
			// Currently, rest of the XFA codebase  does not support more than two columns.
			// Designer does not have widget support for more than two columns.
			// Therefore, return FALSE
			// Once the support for more than two columns is implemented, this if statement should go away.

			oRetVal.setBool(false);
			return;
		}
		boolean bMultiColumn = numColumns > 1;
		

		int len = sItemValueList.length();	
		int nBeginToken, nPrevEndToken = 0;
		int numDisplayItems = 0;
		int numSaveValues = 0;
		ItemPair itemPair = new ItemPair();
		((Field)pObj).getItemLists(false, itemPair, bMultiColumn);
		oDisplayItems = itemPair.mDisplayItems;
		oSaveItems = itemPair.mSaveItems;
		for (nBeginToken = 0; nBeginToken < len; ) {
			// get all display values per saveValue
			int col = 0;
			int nTokenLen = 0;
			for (col = 0; col < numColumns - 1 ; col++) {
				// getToken
				nTokenLen = StringUtils.skipUntil(sItemValueList, sSkipSet, nBeginToken);
				sToken.setLength(0);
			    sToken.append(sItemValueList.substring(nBeginToken, nTokenLen));
				nPrevEndToken= nBeginToken + nTokenLen;
				nBeginToken = nPrevEndToken + 1;
				
				while (sItemValueList.charAt(nPrevEndToken) == '\\' ) {
					// escape backslash and append the escaped character
					sToken.append(sItemValueList.charAt(nBeginToken)); // note that nBeginToken will increment by 1 during this call.
					nTokenLen = StringUtils.skipUntil(sItemValueList, sSkipSet, nBeginToken);
					sToken.append(sItemValueList.substring(nBeginToken, nTokenLen));
					nPrevEndToken = nBeginToken + nTokenLen;
					nBeginToken = nPrevEndToken + 1;
				}
				
				sDisplayVal = sToken.toString();	
				numDisplayItems++;
				
				if (oDisplayItems != null)	
					((Items)oDisplayItems).addItem(sDisplayVal, false);	
				
			}
			// get save value. Note that for a 1-column item list, save and display values are the same.
			// If the string is already consumed, sSaveVal is made to be the last parsed token.
			// This handles the corner case of setItems("one,1,two", 2). The save value for one is 1, for two is two.
			// Since the value for two is not specified, setItems will return FALSE.
			if (nBeginToken <= len ) {
				nTokenLen = StringUtils.skipUntil(sItemValueList, sSkipSet, nBeginToken);
				sToken.setLength(0);
				sToken.append(sItemValueList.substring(nBeginToken, nTokenLen));
				nPrevEndToken = nBeginToken + nTokenLen;
				nBeginToken = nPrevEndToken + 1;
				
				while (sItemValueList.charAt(nPrevEndToken) == '\\' ) {
					// escape backslash and append the escaped character
					sToken.append(sItemValueList.charAt(nBeginToken)); // note that nBeginToken will increment by 1 during this call.
					nTokenLen = StringUtils.skipUntil(sItemValueList, sSkipSet, nBeginToken);
					sToken.append(sItemValueList.substring(nBeginToken, nTokenLen));
					nPrevEndToken= nBeginToken + nTokenLen;
					nBeginToken=nPrevEndToken+1;
				}
				
				numSaveValues++;
			}
			
			sSaveVal = sToken.toString();
				
			if (sSaveVal.length() == 0) {
				// This would handle a string like "a,1,b,,c,3". "b" is the save and display val.
				sSaveVal = sDisplayVal;
			}
			
			if (!bMultiColumn) { 
				// for 1-column list boxes, save and display values are the same
				if (oDisplayItems != null)	
					((Items)oDisplayItems).addItem(sSaveVal, false);	
			}
			
			if (oSaveItems != null && oSaveItems != oDisplayItems)
				((Items)oSaveItems).addItem(sSaveVal, false);
		}
		
		oRetVal.setBool(true);
		
		if (bMultiColumn && ( numDisplayItems != ((numColumns - 1) * numSaveValues) )) {
			oRetVal.setBool(true);			
		}
	}

	public static void deleteItem(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		oRetVal.setBool(Boolean.valueOf(((Field) pObj).deleteItem(pArgs[0].getInteger().intValue())));
	}

	public static void execCalculate(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		((Field) pObj).execEvent(XFA.CALCULATE);
	}

	public static void execValidate(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		oRetVal.setBool(Boolean.valueOf(((Field) pObj).execValidate()));
	}

	public static void execInitialize(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		((Field) pObj).execEvent("initialize");
	}

	public static void execEvent(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		((Field) pObj).execEvent(pArgs[0].getString());
	}

	public static void boundItem(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		oRetVal.setString(((Field) pObj).getBoundItem(pArgs[0].getString()));
	}

	public static void getItemState(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		oRetVal.setBool(Boolean.valueOf(((Field) pObj).getItemState(pArgs[0].getInteger().intValue())));
	}

	public static void setItemState(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		((Field) pObj).setItemState(pArgs[0].getInteger().intValue(), pArgs[1].getBool().booleanValue());
	}

	public static void getDisplayItem(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		oRetVal.setString(((Field) pObj).getDisplayItem(pArgs[0].getInteger().intValue()));
	}

	public static void getSaveItem(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		oRetVal.setString(((Field) pObj).getBoundItem(pArgs[0].getInteger().intValue()));
	}
}
