// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2011 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package com.adobe.xmp.schema.model.rules;

import com.adobe.xmp.schema.model.SchemaVisitor;
import com.adobe.xmp.schema.model.TypeRule;
import com.adobe.xmp.schema.model.XMPSchemaException;


/**
 * This rule models a comparison of an Integer property with a constant argument.
 * 
 * @author Stefan Makswit
 */
public class IntegerRule implements TypeRule
{
	private static final long serialVersionUID = 1L;
	/** operator used to compare the operand with the actual XMP value */
	private ComparisonOperator operator;
	/** a long value, which is used for the XMP type Integer */
	private long operand;

	
	/**
	 * Constructs a new IntegerRule.
	 *
	 * @param operator the comparison operator
	 * @param value the integer to compare with
	 */
	public IntegerRule(ComparisonOperator operator, long value)
	{
		this.operator = operator;
		this.operand = value;
	}


	/**
	 * @return Returns the operator.
	 */
	public ComparisonOperator getOperator()
	{
		return this.operator;
	}


	/**
	 * @return Returns the operand.
	 */
	public long getOperand()
	{
		return this.operand;
	}
	
	
	/**
	 * @see com.adobe.xmp.schema.model.TypeRule#accept(com.adobe.xmp.schema.model.SchemaVisitor)
	 */
	public void accept(SchemaVisitor schemaVisitor) throws XMPSchemaException
	{
		schemaVisitor.visit(this);
	}
}
