/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.api.collection;

import aQute.bnd.annotation.ProviderType;
import com.day.cq.search.Query;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.resource.collection.ResourceCollection;

import javax.jcr.RepositoryException;
import java.io.IOException;
import java.util.Iterator;

/**
 * This interface defines a SmartCollection. Should be used, when working with Smart Collections
 * i.e. collection with no static member, rather a query string.
 */
@ProviderType
public interface SmartCollection extends ResourceCollection {
    /**
     * returns the query object that is used to query collection members.
     * @return <code>Query</code> object
     * @throws IOException thrown if an error occurs while reading from the binary stream
     * @throws RepositoryException thrown if an error occurs while accessing items in repository
     */
    Query getQuery() throws IOException, RepositoryException;
    
    /**
     * Returns an iterator over resources referred in the collection starting from position 
     * specified by the parameter "offset". The size of the iterator is limited by the
     * parameter "limit". 
     *
     * @return iterator over the subset of resources referred in collection.
     */
    Iterator<Resource> getResources(long offset, long limit);
}
