/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.replication;

/**
 * Main exception thrown by classes in this package. May either contain
 * an error message or another exception wrapped inside this exception.
 */
public class ReplicationException extends Exception {

    private static final long serialVersionUID = -243436984989531373L;

    /**
     * Creates a <code>ReplicationException</code> given
     * a message describing the failure cause
     * @param s description
     */
    public ReplicationException(String s) {
        super(s);
    }

    /**
     * Creates a <code>ReplicationException</code> given
     * a message describing the failure cause and a root
     * exception
     * @param s description
     * @param e root failure cause
     */
    public ReplicationException(String s, Exception e) {
        super(s, (e instanceof ReplicationException ? ((ReplicationException)e).getCause() : e));
    }

    /**
     * Creates a <code>ReplicationException</code> given
     * a root exception
     * @param e root failure cause
     */
    public ReplicationException(Exception e) {
        super(e);
    }
}
