/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.tagging;

import aQute.bnd.annotation.ProviderType;

/**
 * Constants for tagging, mainly JCR nodetype and property names.
 */
@ProviderType
public interface TagConstants {
    
    /**
     * JCR node type that defines a tag. 
     */
    String NT_TAG = "cq:Tag";
    
    /**
     * JCR mixin type to use on content resources (such as pages or assets) that allows them to be associated with tags ("be tagged") 
     * by bringing in the cq:tags property (PN_TAGS), and allow to find content tagged with certain tags.
     */
    String NT_TAGGABLE = "cq:Taggable";
    
    /**
     * Name of the JCR multi-value string property on content resources that stores the associated tags. 
     * The values are tag IDs pointing to the tags. This property is normally defined as part of the cq:Taggable mixin. 
     * To change the associated tags, do not modify this JCR property directly through the JCR API, but only through the TagManager API instead.
     */
    String PN_TAGS = "cq:tags";
    
    /**
     * Name of a JCR string property on cq:Tag nodes that marks that a tag has been moved to or merged with a different tag 
     * (but the tag needs to be present to resolve stale tag id references). The value is the tag id of the new tag. 
     * This property is entirely managed by the tagging module.
     */
    String PN_MOVED_TO = "cq:movedTo";
    
    /**
     * Name of a JCR multi-value string property on cq:Tag nodes that lists all previous tags that have been moved to or merged with this tag. 
     * It is the opposite of the cq:backlinks property. This property is entirely managed by the tagging module
     */
    String PN_BACKLINKS = "cq:backlinks";
    
    /**
     * A special value for the cq:movedTo property.It is applied when the tag is deleted but cannot be removed 
     * from the repository because there are subtags with a cq:movedTo that must be kept.
     */
    String MARKED_AS_DELETED = "nirvana";
    
    /**
     * Tags are classified by namespace which is also a tag and define a set/class of a specific type of tags. 
     * The colon separates the namespace from 'Local ID'.
     */
    char NAMESPACE_DELIMITER_CHR = ':';
    /**
     * String representation of NAMESPACE_DELIMITER_CHR.
     */
    String NAMESPACE_DELIMITER = new String(new char[] {NAMESPACE_DELIMITER_CHR});
    /**
     * It used to represent hierarchy model of the tag framework.
     */
    String SEPARATOR = "/";
    
    /**
     * Another formated version of NAMESPACE_DELIMITER.
     */
    String TITLEPATH_NS_DELIMITER = " " + NAMESPACE_DELIMITER_CHR + " "; 
    
    /**
     * Another formated version of SEPARATOR.
     */
    String TITLEPATH_DELIMITER = " " + SEPARATOR + " "; 
    
    /**
     * Name of the special default tag namespace. This is used if a full tag id does not include a namespace. 
     * Not related to JCR namespaces.
     */
    String DEFAULT_NAMESPACE = "default";
    /**
     * TagId for 'default' NAMESPACE.
     */
    String DEFAULT_NAMESPACE_ID = DEFAULT_NAMESPACE + NAMESPACE_DELIMITER;
    
    /**
     * Legacy tag root path.
     */
    String LEGACY_TAG_ROOT_PATH = "/etc/tags";
    
    /**
     * Tag root path.
     */
    String TAG_ROOT_PATH = "/content/cq:tags";
}
