/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter.parser;

/**
 * Enumerates the supported HTML content types
 */
public enum HTMLContentType {

    /**
     * Meta content
     */
    META,

    /**
     * Markup content
     */
    MARKUP,

    /**
     * External javascript included via <script src="some.js"/>
     */
    SCRIPT_INCLUDE,

    /**
     * Inline javascript within the <script> tag
     */
    SCRIPT_INLINE,

    /**
     * inline styles within the <style> tag
     */
    STYLES_INLINE,

    /**
     * External css included via <link rel="stylesheet" href="some.css"/>
     */
    STYLESHEET_INCLUDE
}
