/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.exec;

import java.util.List;

import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.model.WorkflowNode;
import com.day.cq.workflow.model.WorkflowTransition;

/**
 * <code>Route</code> represents the possible next destinations which will be
 * selectable after a {@link WorkItem} is completed.
 */
public interface Route {
	/**
	 * Returns a unique ID for the route. This ID must be unique across all
	 * routes that are returned from
	 * <code>{@link WorkflowSession#getRoutes(WorkItem)}</code>.
	 * 
	 * @return The ID of the route.
	 */
	String getId();

	/**
	 * Returns the a user friendly name for the route.
	 * 
	 * @return The name of the route.
	 */
	String getName();

	/**
	 * Indicates if one the <code>Route</code>s {@link WorkflowTransition}s
	 * is marked as default.
	 * 
	 * @return True if one {@link WorkflowTransition} is marked as default,
	 *         otherwise false.
	 */
	boolean hasDefault();

	/**
	 * Returns the list of possible destinations.
	 * 
	 * @return List of {@link WorkflowTransition}s that lead selectable
	 *         {@link WorkflowNode}s.
	 */
	List<WorkflowTransition> getDestinations();

	/**
	 * Returns true if the route defines to a {@link WorkflowNode} which has
	 * already been passed.
	 * 
	 * @return <code>true</code> if it is a "back" route otherwise
	 *         <code>false</code>
	 */
	boolean isBackRoute();
}
