/*
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2019 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
package com.adobe.cq.inbox.api.preferences.domain.view;

import org.osgi.annotation.versioning.ProviderType;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Interface for the AEM Inbox View Preferences
 */
@ProviderType
public interface ViewPreferences {

    /**
     * Returns the property by which AEM inbox items are sorted
     * or null if property is not present
     * @return The property by which AEM inbox items are sorted
     */
    @Nullable String getSortByProperty();

    /**
     * Set the property by which AEM inbox items are sorted
     * or null to clear current property
     * @param sortByProperty The property by which AEM inbox items are sorted
     */
    void setSortByProperty(@Nullable String sortByProperty);

    /**
     * Returns the sort order of AEM inbox items (Ascending/Descending)
     * or null if property is not present
     * @return The sort order of AEM inbox items
     */
    @Nullable String getSortOrder();

    /**
     * Set the sort order of AEM inbox items (Ascending/Descending)
     * or null to clear current property
     * @param sortOrder The sort order of AEM inbox items
     */
    void setSortOrder(@Nullable String sortOrder);
}
