/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.msm.ui.rendercondition;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.adobe.granite.ui.components.rendercondition.RenderCondition;


/**
 * A condition that decides based on
 * {@link Session#hasCapability(String, Object, Object[])}.
 */
public class CapabilityRenderCondition implements RenderCondition {

    private final static Logger log = LoggerFactory.getLogger(CapabilityRenderCondition.class);
    private Session session;
    private String[] paths;
    private String[] methods;

    public CapabilityRenderCondition(Session session, String[] paths, String[] methods) throws RepositoryException {
        this.session = session;
        this.paths = paths;
        this.methods = methods;
    }

    public boolean check() throws ServletException {
        try {
            for (String path: this.paths) {
                if (!session.nodeExists(path)) {
                    continue;
                }
                Node node = session.getNode(path);
                if (node == null) {
                    return false;
                }
                for(String method : methods) {
                    if (!session.hasCapability(method, node, new Object[]{"testObj"})) {
                        return false;
                    }
                }
            }
            return true;

        } catch (RepositoryException e) {
            log.error("Error while accessing a node ", e);
            return false;
        }
    }
}