/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.asset.api;

import org.apache.sling.api.resource.ModifiableValueMap;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <code>AssetRelation</code> defines the {@link Asset} relation.
 * <p>
 * To get a relation see {@link Asset#listRelations(String)}.
 * To create a relation see {@link Asset#addRelation(String, String, java.util.Map)} and
 * {@link Asset#addRelation(String, String)}
 * 
 * To update additional properties for a relation see {@link #getProperties()}
 * <p>
 * 
 * @since 1.3
 */
@ProviderType
public interface AssetRelation {

	  /**
	   * Returns the related <code>Asset</code>
	   * 
	   * @return asset instance of related asset
	   */
	  public Asset getAsset();

	  /**
	     * Returns additional properties for the Asset relation. It returns 
	     * a <code>ModifiableValueMap</code>, that can be used to modify existing
	     * relation properties. 
	     * If there are no properties, then null is returned (this will only happen
	     * for relation created with older api {@link Asset#setRelation(String, String)})
	     * 
	     * @return properties of the Asset Relation as <code>ModifiableValueMap</code>, returns null if no properties found.
	     */
	  public ModifiableValueMap getProperties();

	  /**
	   * Returns the name of the relation
	   * 
	   * @return name of the relation
	   */
	  public String getName();
}
