/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.haf.converter.api;

import org.osgi.annotation.versioning.ProviderType;

/**
 * Factory for retrieving HypermediaConverter instances
 */
@ProviderType
public interface HypermediaConverterFactory {

    /**
     * Return the system's default Hypermedia converter.  Typically this would be used when the client doesn't
     * request a specific media type in the accepts header.
     * @return The default Hypermedia converter instance
     */
    HypermediaConverter getDefaultConverter();

    /**
     * Return the Hypermedia converter responsible for serializing Resources for the specific media type.  If no
     * converters are found that support the request media type then the system's default Hypermedia converter is
     * returned.
     * @param mediaType  The media type being requested.
     * @return The Hypermedia converter instance
     */
    HypermediaConverter getConverter(ContentType mediaType);

}
