/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.oauth.jwt;

import java.security.Key;

/**
 * Create an instance of a {@link com.adobe.granite.oauth.jwt.JwsBuilder JwsBuilder} 
 * @see JwsBuilder
 */
public interface JwsBuilderFactory {
    
    /**
     * Get an instance of a JwsBuilder
     * 
     * @param algorithm The algorithm used to sign the JWS
     * @param key The key used to sign the JWS. 
     * This must be @link javax.crypto.spec.SecretKeySpec in case of symmetric algorithm and 
     * @link java.security.PrivateKey in case of asymmetric algorithm
     * @return JwsBuilder
     * @throws IllegalArgumentException if the given algorithm is not compatible with the given key
     * @throws UnsupportedOperationException if the given algorithm is not supported
     * 
     */
    public JwsBuilder getInstance(String algorithm, Key signingKey);
    
    /**
     * Get an instance of a JwsBuilder.
     * The JWS will be signed using a system key compatible with the given algorithm (if available)
     * 
     * @param algorithm the algorithm used to sign the JWS
     * @return JwsBuilder
     * @throws UnsupportedOperationException if it doesn't exist a system key for the given algorithm
     */
    public JwsBuilder getInstance(String algorithm);
}
