/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.timeline;

import org.apache.sling.api.resource.Resource;

import java.util.List;

/**
 * A <code>Timeline</code> provides a collection of {@link TimelineEvent}s specific to a {@link Resource}. The type of
 * events provided is dependent on the available {@link TimelineEventProvider}s registered in the system. By default the
 * following events are provided: <ul> <li>Versioning Events</li> <li>Workflow Events</li> <li>Annotation Events</li>
 * </ul> A Timeline can be retrieved by adapting a resource as follows: <code>resource.adaptTo(Timeline.class)</code>.
 * Any resource can be adapted. Whether events are provided for a resource is decided by the event providers.
 */
public interface Timeline {

    /**
     * Returns the {@link Resource} for which this timeline was created.
     *
     * @return The {@link Resource}.
     */
    Resource getResource();

    /**
     * Returns a {@link List} of all {@link TimelineEvent}s available for the resource backing the timeline. If no
     * events are found, an empty collection is returned. The list is ordered chronologically (most recent last) as per
     * {@link com.adobe.granite.timeline.TimelineEvent#getTime()}. In order to trim the result (e.g. for pagination, use
     * <code>getEvents().subList(start, end)</code>.
     *
     * @return A {@link List} of {@link TimelineEvent}s, or an empty collection if no events were found.
     */
    List<TimelineEvent> getEvents();

    /**
     * Returns a subset of events (as provided by {@link #getEvents()}), filtered by the given <code>types</code>. The
     * types by which to filter are provided as an array of {@link TimelineEventType}s. The {@link TimelineAggregator}
     * service provides access to the available types (see {@link com.adobe.granite.timeline.TimelineAggregator#getTypes()}.
     * The list is ordered chronologically (most recent last) as per {@link com.adobe.granite.timeline.TimelineEvent#getTime()}.
     * In order to trim the result (e.g. for pagination, use <code>getEvents(type).subList(start, end)</code>.
     *
     * @param types The array of {@link TimelineEventType}s by which to filter events.
     *
     * @return A {@link List} of {@link TimelineEvent}s filtered by type, or an empty list if no events or none of the
     *         given types were found.
     */
    List<TimelineEvent> getEvents(TimelineEventType... types);
}
