/*
* File: EncodedData.java
*
*************************************************************************
** ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2011 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
  from Adobe Systems Incorporated.
**************************************************************************/

package com.adobe.internal.pdftoolkit.core.util;

/**
 * This class holds the encoding name and the length of 
 * data after encoding is applied.
 * @author hkansal
 *
 */
public class EncodedData<T>{
	private T encodedOutput;
	/**
	 * Constructor to get the new object.
	 * @param encoding
	 * @param encodedDataLength
	 */
	public EncodedData(Encoding encoding, int encodedDataLength, T encodedOutput){
		this.encodedDataLength = encodedDataLength;
		this.encoding = encoding;
		this.encodedOutput = encodedOutput;
	}
	Encoding encoding;
	/**
	 * Returns the encoding name.
	 * @return {@link Encoding}
	 */
	public Encoding getEncoding() {
		return encoding;
	}
	/**
	 * Sets the encoding name.
	 * @param encoding
	 */
	public void setEncoding(Encoding encoding) {
		this.encoding = encoding;
	}
	int encodedDataLength;
	/**
	 * Returns the length of encoded data.
	 * @return int
	 */
	public int getEncodedDataLength() {
		return encodedDataLength;
	}
	/**
	 * Sets the length of encoded data.
	 * @param encodedDataLength
	 */
	public void setEncodedDataLength(int encodedDataLength) {
		this.encodedDataLength = encodedDataLength;
	}
	
	public T getEncodedOutput(){
		return this.encodedOutput;
	}
	
	public void setEncodedOutput(T encodedOutput){
		this.encodedOutput = encodedOutput;
	}
}
