/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa.data;

import com.adobe.xfa.Arg;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ObjScript;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptFuncObj;
import com.adobe.xfa.ScriptPropObj;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.XFA;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;


/**
 * This class contains all the script functionality associated with the
 * Node class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class DataWindowScript extends ObjScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ObjScript.moScriptTable,
		"dataWindow",
		new ScriptPropObj[] {
			new ScriptPropObj(DataWindowScript.class, "recordsBefore", "getRecordsBefore", null, Arg.INTEGER, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_DATAWINDOW_RECORDSBEFORE, 0*/, 0),
			new ScriptPropObj(DataWindowScript.class, "recordsAfter", "getRecordsAfter", null, Arg.INTEGER, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_DATAWINDOW_RECORDSAFTER, 0*/, 0),
			new ScriptPropObj(DataWindowScript.class, "currentRecordNumber", "getCurrentRecordNumber", null, Arg.INTEGER, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_DATAWINDOW_CURRENTRECORDNUMBER, 0*/, 0),
			new ScriptPropObj(DataWindowScript.class, "isDefined", "getIsDefined", null, Arg.BOOL, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_DATAWINDOW_ISDEFINED, 0*/, 0)
		},
		new ScriptFuncObj[] {
			new ScriptFuncObj(DataWindowScript.class, "record", "record", Arg.OBJECT,
				new int[] { Arg.INTEGER/*, XFA_IS_DATAWINDOW_RECORD_PARAM*/ }, 1, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_DATAWINDOW_RECORD_DESC, XFA_IS_DATAWINDOW_RECORD_RET, null*/, 0),
			new ScriptFuncObj(DataWindowScript.class, "moveCurrentRecord", "moveCurrentRecord", Arg.EMPTY,
				new int[] { Arg.INTEGER/*, XFA_IS_DATAWINDOW_MOVECURRENTRECORD_PARAM*/ }, 1, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_DATAWINDOW_MOVECURRENTRECORD_DESC, 0, null*/, 0),
			new ScriptFuncObj(DataWindowScript.class, "gotoRecord", "gotoRecord", Arg.EMPTY,
				new int[] { Arg.INTEGER/*, XFA_IS_DATAWINDOW_GOTORECORD_PARAM*/ }, 1, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_DATAWINDOW_GOTORECORD_DESC, 0, null*/, 0),
			new ScriptFuncObj(DataWindowScript.class, "isRecordGroup", "isRecordGroup", Arg.BOOL,
				new int[] { Arg.OBJECT/*, XFA_IS_DATAWINDOW_ISRECORDGROUP_PARAM*/ }, 1, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_DATAWINDOW_ISRECORDGROUP_DESC, XFA_IS_DATAWINDOW_ISRECORDGROUP_RET, null*/, 0)
		}
	);

	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}

	public static void getRecordsBefore(Obj pObj, Arg oRetVal) {
		oRetVal.setInteger(Integer.valueOf(((DataWindow) pObj).recordsBefore()));
	}

	public static void getRecordsAfter(Obj pObj, Arg oRetVal) {
		oRetVal.setInteger(Integer.valueOf(((DataWindow) pObj).recordsAfter()));
	}

	public static void getCurrentRecordNumber(Obj pObj, Arg oRetVal) {
		oRetVal.setInteger(Integer.valueOf(((DataWindow) pObj).currentRecordNumber()));
	}

	public static void getIsDefined(Obj pObj, Arg oRetVal) {
		oRetVal.setBool(Boolean.valueOf(((DataWindow) pObj).isDefined()));
	}

	public static void record(Obj pObj,Arg oRetVal, Arg[] pArgs) {
		oRetVal.setObject(((DataWindow) pObj).record(pArgs[0].getInteger().intValue()));
	}

	public static void moveCurrentRecord(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		((DataWindow) pObj).moveCurrentRecord(pArgs[0].getInteger().intValue());
	}

	public static void gotoRecord(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		((DataWindow) pObj).gotoRecord(pArgs[0].getInteger().intValue());
	}

	public static void isRecordGroup(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		// check the type
		Obj oObject = pArgs[0].getObject();
		if (! oObject.isSameClass(XFA.DATAGROUP))
			throw new ExFull(ResId.ArgumentMismatchException);
		oRetVal.setBool(Boolean.valueOf(((DataWindow) pObj).isRecordGroup((DataNode) oObject)));
	}
}
