/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.testandtarget;

/**
 * The {@code TestandtargetCampaignMediator} creates and keeps in sync Test and Target campaigns based on the data
 * from a CQ campaign
 */
@Deprecated
public interface TestandtargetCampaignMediator {
    
    /**
     * Creates or updates a test and target 'author' campaign
     * 
     * <p>This method does nothing if the {@code campaignPath} does not point to a valid campaign.</p>
     * 
     * @param campaignPath the path of the {@code Page} which represents a test and target campaign or is a child of a
     *            campaign
     * @throws TestandtargetException {@link TestandtargetException}
     */
    void syncAuthorCampaign(String campaignPath) throws TestandtargetException;

    /**
     * Creates or updates a test and target 'publish' campaign
     * 
     * <p>This method does nothing if the {@code campaignPath} does not point to a valid campaign.</p>
     * 
     * @param campaignPath the path of the {@code Page} which represents a test and target campaign or is a child of a
     *            campaign
     * @throws TestandtargetException {@link TestandtargetException}
     */
    void syncPublishCampaign(String campaignPath) throws TestandtargetException;

    /**
     * Deactivates a test and target 'publish' campaign
     * 
     * <p>
     * This method does nothing if the {@code campaignPath} does not point to a valid campaign.
     * </p>
     * 
     * @param campaignPath the path of the {@code Page} which represents a test and target campaign or is a child of a
     *            campaign
     * @throws TestandtargetException {@link TestandtargetException}
     */
    void deactivatePublishCampaign(String campaignPath) throws TestandtargetException;
}