/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.commons.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This class provides various utility methods pertaining to DAM Mime Type Service Implementation.
 *
 * @deprecated since 6.6. Please use a service-reference of {@link DamMimeUtils} instead
 */
public class DamMimeUtil {

    private static final Logger log = LoggerFactory.getLogger(DamMimeUtil.class);

    private static boolean allowAllMime = true;

    private static boolean detectMimeFromContent = false;

    private static final List<String> supportedMimeTypes = new ArrayList<String>();

    public static void setAllowAllMimeAttribute(boolean val) {
        allowAllMime = val;
    }

    public static void setDetectMimeFromContent(boolean val) {
        detectMimeFromContent = val;
    }

    public static void setSupportedMimeTypes(String[] mimeList) {
        supportedMimeTypes.clear();
        supportedMimeTypes.addAll(Arrays.asList(mimeList));
    }

    public static boolean isAllowedMimeType(String nameMimeType, String contentMimeType) {
        // TODO: (ashishc) add more 'sophisticated' logic to accept/reject asset
        if (StringUtils.isEmpty(contentMimeType)) {
            contentMimeType = nameMimeType;
        }
        log.trace("Detected mimeType: {}", contentMimeType);
        if(allowAllMime){
            log.trace("upload allowed");
            return true;
        } else if (StringUtils.isEmpty(contentMimeType)) {
            return false;
        }

        for(String regEx : supportedMimeTypes){
            if(contentMimeType.matches(regEx)) {
                log.trace("upload allowed");
                return true;
            }
        }
        log.trace("upload NOT allowed");
        return false;
    }

    public static boolean getDetectMimeFromContent() {
        return detectMimeFromContent;
    }
}
