/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.commons.util;

import java.util.Iterator;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.DamConstants;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;

/**
 * A {@link RenditionPicker} that picks the first rendition found which name
 * starts with a given prefix.
 */
public class PrefixRenditionPicker implements RenditionPicker {

    private String prefix;
    private boolean returnOriginal;

    /**
     * Picks the first rendition found which name starts with the given prefix.
     * If no matching rendition was found, <code>null</code> will be returned.
     *
     * @param startsWith the name prefix to match
     */
    public PrefixRenditionPicker(String startsWith) {
        this(startsWith, false);
    }

    /**
     * Picks the first rendition found which name starts with the given prefix.
     * It can be defined what to return if no matching rendition was found
     * (original rendition or <code>null</code>).
     *
     * @param prefix
     *            the name prefix to match
     * @param returnOriginal
     *            if true, will return the original rendition if no matching
     *            rendition was found, otherwise the picker will return
     *            <code>null</code>
     */
    public PrefixRenditionPicker(String prefix, boolean returnOriginal) {
        this.prefix = prefix;
        this.returnOriginal = returnOriginal;
    }

    public Rendition getRendition(Asset asset) {
        // 1. try to find a matching rendition
        final Iterator<Rendition> renditions = asset.listRenditions();
        return getRendition(renditions);
    }

    public Rendition getRendition(final Iterator<Rendition> renditions) {
        Rendition original = null;
        while ( renditions.hasNext() ) {
            final Rendition rendition = renditions.next();
            if(DamConstants.ORIGINAL_FILE.equals(rendition.getName())){
                original = rendition;
            }
            if (rendition.getName().startsWith(prefix)) {
                return rendition;
            }
        }

        if (returnOriginal) {
            // 2. return current rendition
            return original;
        } else {
            return null;
        }
    }

}
