/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api;

import org.apache.sling.api.resource.Resource;

import java.util.Iterator;

public interface Scene7PresetsService {

    /**
     * The path to the encoding presets, relative to the cloud config root.
     */
    public static final String REL_PATH_ENCODING_PRESETS = "presets/encoding";

    /**
     * The path to the viewer presets, relative to the cloud config root.
     */
    public static final String REL_PATH_VIEWER_PRESETS = "presets/viewer";

    /**
     * Get all encoding presets available for the given cloud config resource. Including the shared encoding presets.
     *
     * @param configResource The cloud config resource to get the encoding presets for.
     * @return Iterator of encoding preset resources.
     */
    Iterator<Resource> getEncodingPresets(Resource configResource);

    /**
     * Get all viewer presets available for the given cloud config resource. Including the shared viewer presets.
     *
     * @param configResource The cloud config resource to get the viewer presets for.
     * @return Iterator of viewer preset resources.
     */
    Iterator<Resource> getViewerPresets(Resource configResource);


    /**
     * Update and cache the encoding presets from S7 server for the given cloud config resource.
     *
     * @param configResource The cloud config resource to update and cache the encoding presets for.
     * @return <code>True</code> if update and caching was successful, <code>false</code> otherwise.
     */
    boolean updateEncodingPresets(Resource configResource);


    /**
     * Update and cache the viewer presets from S7 server for the given cloud config resource.
     *
     * @param configResource The cloud config resource to update and cache the viewer presets for.
     * @return <code>True</code> if update and caching was successful, <code>false</code> otherwise.
     */
    boolean updateViewerPresets(Resource configResource);

}
