/*
 * ***********************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2011 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 * ***********************************************************************
 */

package com.day.cq.personalization.tags;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.personalization.ClientContextUtil;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.jsp.util.TagUtil;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;

public class StoreRendererTag extends TagSupport {

    private static final long serialVersionUID = 4646561799994266940L;

    private String store;

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
    }

    public void setStore(String store) {
        this.store = store;
    }

    @Override
    public int doEndTag() throws JspException {
        final JspWriter out = pageContext.getOut();
        final SlingHttpServletRequest request = TagUtil.getRequest(pageContext);
        try {
            out.println(getScript(request));

        } catch (IOException e) {
            throw new JspException("Could not write script for context profile property", e);
        }

        return EVAL_PAGE;
    }

    String getScript(SlingHttpServletRequest request) {
        SlingBindings bindings = (SlingBindings) request.getAttribute(SlingBindings.class.getName());
        XSSAPI xssAPI = bindings.getSling().getService(XSSAPI.class).getRequestSpecificAPI(request);

        StringBuilder res = new StringBuilder();

        String prefixId = ClientContextUtil.getId(request.getResource().getPath());
        String id = prefixId + "-" + store;
        res.append("<div");
        res.append(" id=\"").append(xssAPI.encodeForHTMLAttr(id)).append("\"");
        res.append(" class=\"cq-cc-").append(xssAPI.encodeForHTMLAttr(store)).append("\"");
        res.append(">");
        res.append("</div>");

        res.append("<script type=\"text/javascript\">\n");
        res.append("if( window.CQ_Analytics ) {");
        res.append("CQ_Analytics.ClientContextUtils.renderStore(");
        res.append("'").append(xssAPI.encodeForJSString(id)).append("',");
        res.append("'").append(xssAPI.encodeForJSString(store)).append("'");
        res.append(");");
        res.append("}");
        res.append("</script>");

        return res.toString();
    }
}
