/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.api;

import javax.servlet.ServletRequest;

/*
 * Authoring UI mode is read from request to determine which editor should be
 * used to modify WCM pages' content.
 */
public enum AuthoringUIMode {

    /**
     * Classic authoring UI mode
     */
    CLASSIC,

    /**
     * Touch-Optimized authoring UI mode
     */
    TOUCH;

    /**
     * Name of the <code>AuthoringUIMode</code> request attribute
     */
    public static final String REQUEST_ATTRIBUTE_NAME = AuthoringUIMode.class.getName();

    /**
     * Returns the current authoring UI mode of this request.
     *
     * @param request Servlet request
     * @return current authoring UI mode
     */
    public static AuthoringUIMode fromRequest(ServletRequest request) {
        return (AuthoringUIMode) request.getAttribute(REQUEST_ATTRIBUTE_NAME);
    }

}
