/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.exec;

import com.day.cq.workflow.HasMetaData;

/**
 * A <code>WorkflowData</code> instance "carries" the data pushed through the
 * {@link Workflow}.
 */
public interface WorkflowData extends HasMetaData {
	/**
	 * Getter for the payload of the <code>WorkflowData</code>.
	 * 
	 * @return The payload of the <code>WorkflowData</code>.
	 */
	Object getPayload();

	/**
	 * Getter for the type of payload of the <code>WorkflowData</code>.
	 * 
	 * @return The type of payload of the <code>WorkflowData</code>.
	 */
	String getPayloadType();
}
