/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2018 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.adobeims.imsprofile;

import org.apache.sling.commons.json.JSONObject;

/**
 * A {@link RuntimeException} thrown by the {@link ImsProfileService}
 * if an error occurs while requesting the IMS profile API.
 */
public class ImsProfileException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    private JSONObject apiResponse;

    public ImsProfileException(String message) {
        super(message);
    }

    public ImsProfileException(String message, Throwable cause) {
        super(message, cause);

        // keep the api response
        if (cause instanceof ImsProfileException) {
            apiResponse = ((ImsProfileException) cause).getApiResponse();
        }
    }

    /**
     * Constructor with the possibility to add the api response.
     *
     * @param message     error message
     * @param apiResponse api response with information about the error
     */
    public ImsProfileException(String message, JSONObject apiResponse) {
        super(message);
        this.apiResponse = apiResponse;
    }

    /**
     * @return api response if available, might be null
     */
    public JSONObject getApiResponse() {
        return apiResponse;
    }
}
