/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.adobe.cq.dam.cfm;

/**
 * This class defines the OOTB semantic types provided by Content Fragments.
 *
 * @since 1.7.0
 */
public final class SemanticDataType {

    private SemanticDataType() {
        // prevent instantiation
    }

    /**
     * Semantic type: Reference to another content fragment
     */
    public static final String CONTENT_FRAGMENT = "content-fragment";

    /**
     * Semantic type: Path reference
     */
    public static final String REFERENCE = "reference";

    /**
     * Semantic type: A JSON structure
     */
    public static final String JSON = "json";

    /**
     * Semantic type: A multiline text (with a certain content type)
     */
    public static final String MULTILINE = "multiline";

    /**
     * Semantic type: Date and time
     */
    public static final String DATETIME = "datetime";

    /**
     * Semantic type: Date only
     */
    public static final String DATE = "date";

    /**
     * Semantic type: Time only
     */
    public static final String TIME = "time";

    /**
     * Semantic type: Tag
     */
    public static final String TAG = "tag";

    /**
     * Semantic type: Color
     */
    public static final String COLOR = "color";

}
