/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.adobe.cq.dam.index.builder;

import com.google.common.collect.ImmutableMap;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import java.util.HashMap;
import java.util.List;

/**
 * This class represents Oak Lucene Index Aggregation Rule
 */
@Deprecated
public class AggregationRule {

    String primaryType;
    List<String> includes;

    /**
     * Creates an <code>AggregationRule</code> for given primaryType
     *
     * @param primaryType primaryType for which aggregation rule is defined
     * @param includes    contains list of paths to be included under given
     *                    primary type aggregate
     */
    public AggregationRule(String primaryType, List<String> includes) {
        this.primaryType = primaryType;
        this.includes = includes;
    }

    /**
     * Creates <code>AggregationRule</code> under given resource
     *
     * @param resource resource under which AggregationRule will be created
     * @throws PersistenceException
     */
    public void build(Resource resource) throws PersistenceException {

        ResourceResolver resolver = resource.getResourceResolver();

        Resource aggregateNode = resolver.create(resource, primaryType, new HashMap<String, Object>());

        for (int i = 0; i < includes.size(); i++) {
            resolver.create(aggregateNode, "include" + i,
                    ImmutableMap.of(LuceneIndexConstants.AGG_PATH, (Object) includes.get(i)));
        }
    }

}
