/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/
package com.adobe.cq.dam.mac.sync.helper;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

/**
 * Adobe Marketing Cloud cloud service configuration.
 */
public interface MACTenantConfiguration {

    // CONSTANTS --------------------------------------------------------------------------------------------------------------------------/
    public static final String JCR_PROP_MAC_DAM_ROOT = "macSyncFolders";
    public static final String MAC_CONFIG_ROOT = "/etc/cloudservices/marketingcloud";
    public static final String RESOURCE_TYPE = "dam/components/marketingcloud/config";

    public static final String MP_CONFIG_ROOT = "/etc/cloudservices/mediaportal";
    public static final String MP_RESOURCE_TYPE = "dam/components/mediaportal/config";

    public static final String JCR_PROP_TENANT = "tenant";
    public static final String JCR_PROP_TENANT_URL = "tenantURL";
    public static final String JCR_PROP_AUD = "audience";

    public static final String JCR_PROP_CLIENT_ID = "clientId";
    public static final String JCR_PROP_SCOPES = "oauthScopes";
    public static final String JCR_PROP_SYNC_ENABLED = "syncEnabled";
    public static final String JCR_PROP_PUB_FOLDER = "pubFolder";
    

    /**
     * Returns the tenant's name, as used in the login URL.
     *
     * @return a String with the tenant name
     */
    String getTenant();

    /**
     * Returns the tenant URL for the allocated instance.
     *
     * @return a String with the URL
     */
    String getTenantURL();

    /**
     * Returns the local aem user used for managing key pair. This user will be used in agent config for the agent,
     * so should have replication permission.
     * It is created automatically if does not exist already.
     *
     * @return a String containing the CQ user ID
     */
    String getDAMUser();

    /**
     * Returns the client id configured for oAuth.
     *
     * @return a String containing the oauth client id
     */
    String getOAuthClientId();

    /**
     * Returns the audience configured for oAuth.
     *
     * @return a String containing the oauth audience
     */
    String getOAuthAudience();

    /**
     * Returns the DAM Folder paths from the MAC instance that will be synchronised.
     *
     * @return a String[] containing the folder paths that needs to be synced from MAC
     */
    String[] getMACSyncPaths();

    /**
     * Returns the configuration's path from the repository.
     *
     * @return the configuration's path
     */
    String getPath();

    /**
     * Returns the {@link Resource} backing this configuration
     *
     * @return the configuration's resource
     */
    Resource getResource();

    /**
     * Returns the synchronisation's status.
     *
     * @return {@code true} if the synchronisation is enabled, {@code false} otherwise
     */
    boolean isSyncEnabled();

    /**
     * Returns the ValueMap properties
     * @return
     */
    ValueMap getProperties();

    /**
     * Get Oauth Scopes
     * @return scopes
     */
    String getOAuthScope();
    
    /**
     * Returns Folder publish public flag. 
     * @return {@code true} if the folder to be published should be public(visible to all users in a tenant), {@code false} otherwise
     */
    boolean isFolderPulishPublic();
}
