package com.adobe.cq.inbox.api;

/*
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2019 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */

/**
 * <code>InboxException</code> is the base class for all inbox related exception
 */
public class InboxException extends Exception {

    /**
     * Constructs a new <code>InboxException</code> with the specified
     * detail message. The cause is not initialized, and may subsequently be
     * initialized by a call to {@link #initCause}.
     *
     * @param message
     *            The detail message. The detail message is saved for later
     *            retrieval by the {@link #getMessage()} method.
     */
    public InboxException(String message) {
        super(message);
    }

    /**
     * Constructs a new <code>InboxException</code> with the specified
     * cause and a detail message of
     * <tt>(cause==null ? null : cause.toString())</tt> (which typically
     * contains the class and detail message of <tt>cause</tt>). This
     * constructor is useful for <code>InboxException</code> that are
     * wrappers for other <code>{@link Throwable}</code>s.
     *
     * @param cause
     *            The cause (which is saved for later retrieval by the
     *            {@link #getCause()} method). (A <tt>null</tt> value is
     *            permitted, and indicates that the cause is nonexistent or
     *            unknown.)
     */
    public InboxException(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs a new <code>InboxException</code> with the specified
     * detail message and cause.
     *
     * @param message
     *            The detail message (which is saved for later retrieval by the
     *            {@link #getMessage()} method).
     * @param cause
     *            The cause (which is saved for later retrieval by the
     *            {@link #getCause()} method). (A <tt>null</tt> value is
     *            permitted, and indicates that the cause is nonexistent or
     *            unknown.)
     */
    public InboxException(String message, Throwable cause) {
        super(message, cause);
    }
}
