/*
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2019 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
package com.adobe.cq.inbox.api.preferences.domain.outofoffice;

import org.osgi.annotation.versioning.ProviderType;

import javax.annotation.Nonnull;
import java.util.List;

/**
 * Interface for the AEM Inbox Out Of Office Preferences
 */
@ProviderType
public interface OutOfOfficePreferences {

    /**
     * Returns if isOurOfOffice property is set to true by user or not.
     * The return value is not sufficient to determine if user is out
     * of office. It will depend on the date range set by the user.
     * @return if ourOfOffice property is set to true by user or not.
     */
    boolean isOutOfOffice();

    /**
     * Sets isOutOfOffice property to true or false.
     * @param isOutOfOffice true or false
     */
    void setOutOfOffice(boolean isOutOfOffice);

    /**
     * Returns the {@link OutOfOfficeDateRange} during which user is out of office
     *  or empty object if configuration is not present
     * @return The {@link OutOfOfficeDateRange} during which user is out of office
     */
    @Nonnull OutOfOfficeDateRange getDateRange();

    /**
     * Returns list of {@link OOOWfModelDesignate} that assign designated tasks
     * to alternate users while user is out of office or empty list if configuration is not present
     * @return The list of {@link OOOWfModelDesignate}
     */
    @Nonnull List<OOOWfModelDesignate> getWfModelSpecificDesignates();

    /**
     * Returns if isOutOfOfficeDesignateProvided property is set to true by user or not.
     * @return if isOutOfOfficeDesignateProvided property is set to true by user or not
     */
    boolean isOutOfOfficeDesignateProvided();

    /**
     * Sets isOutOfOfficeDesignateProvided property to true or false.
     * @param isOutOfOfficeDesignateProvided true or false
     */
    void setOutOfOfficeDesignateProvided(boolean isOutOfOfficeDesignateProvided);
}
